package com.xxfc.platform.order.jobhandler;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ArrayUtil;
import com.github.wxiaoqi.security.admin.feign.UserFeign;
import com.github.wxiaoqi.security.admin.feign.dto.AppUserDTO;
import com.xxfc.platform.order.biz.*;
import com.xxfc.platform.order.biz.inner.OrderMsgBiz;
import com.xxfc.platform.order.contant.enumerate.*;
import com.xxfc.platform.order.entity.*;
import com.xxfc.platform.universal.constant.DictionaryKey;
import com.xxfc.platform.universal.entity.Dictionary;
import com.xxfc.platform.universal.feign.ThirdFeign;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.IJobHandler;
import com.xxl.job.core.handler.annotation.JobHandler;
import com.xxl.job.core.log.XxlJobLogger;
import lombok.extern.slf4j.Slf4j;
import org.assertj.core.util.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import tk.mybatis.mapper.entity.Example;
import tk.mybatis.mapper.weekend.WeekendSqls;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;

import static com.github.wxiaoqi.security.common.constant.CommonConstants.*;
import static com.xxfc.platform.universal.constant.DictionaryKey.APP_ORDER;

/**
 * 订单出车短信提前提醒
 *
 * @author xuxueli 2018-09-16 03:48:34
 */
@JobHandler(value = "remindMsgJobHandler")
@Component
@Slf4j
public class RemindMsgJobHandler extends IJobHandler {

    @Autowired
    BaseOrderBiz baseOrderBiz;

    @Autowired
    OrderRentVehicleBiz orderRentVehicleBiz;

    @Autowired
    OrderTourDetailBiz orderTourDetailBiz;

    @Autowired
    OrderMsgBiz orderMsgBiz;

    @Autowired
    ThirdFeign thirdFeign;

    @Autowired
    UserFeign userFeign;

    @Override
    public ReturnT<String> execute(String idLastNumInterval) {
        try {
            Date tomorrow = DateUtil.offsetDay(DateUtil.parse(DateUtil.today(), "yyyy-MM-dd"), 1);
            Date tomorrowBegin = DateUtil.beginOfDay(tomorrow);
            Date tomorrowEnd = DateUtil.endOfDay(tomorrow);
            //检索明天需要出车的订单
            List<BaseOrder> lists = baseOrderBiz.selectByExample(new Example.Builder(BaseOrder.class)
                    //订单已完成的租车订单
                    .where(WeekendSqls.<BaseOrder>custom()
                                    .andIn(BaseOrder::getType, CollectionUtil.newArrayList(OrderTypeEnum.RENT_VEHICLE.getCode(), OrderTypeEnum.TOUR.getCode()))
                                    .andEqualTo(BaseOrder::getStatus, OrderStatusEnum.ORDER_TOSTART.getCode()) //待出发的订单
                    ).build());

            for(BaseOrder baseOrder : lists) {
                AppUserDTO appUserDTO = userFeign.userDetailById(baseOrder.getUserId()).getData();
                if(OrderTypeEnum.RENT_VEHICLE.getCode().equals(baseOrder.getType())) {
                    OrderRentVehicleDetail orvd = orderRentVehicleBiz.selectById(baseOrder.getDetailId());
                    DateTime startDate = DateUtil.date(orvd.getStartTime());
                    if(startDate.isAfterOrEquals(tomorrowBegin) && startDate.isBeforeOrEquals(tomorrowEnd)) {
                        orderMsgBiz.handelMsgStart(orvd, null, null, baseOrder, appUserDTO);
                    }
                }else {
                    OrderTourDetail otd = orderTourDetailBiz.selectById(baseOrder.getDetailId());
                    DateTime startDate = DateUtil.date(otd.getStartTime());
                    if(startDate.isAfterOrEquals(tomorrowBegin) && startDate.isBeforeOrEquals(tomorrowEnd)) {
                        orderMsgBiz.handelMsgStart(null, otd, null, baseOrder, appUserDTO);
                    }
                }
            }

            return ReturnT.SUCCESS;
        } catch (Exception e) {
            XxlJobLogger.log(e);
            return FAIL;
        } finally {
            ;
        }
    }

}