package com.xxfc.platform.activity.rest;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.xxfc.platform.activity.biz.ActivityPopupBiz;
import com.xxfc.platform.activity.entity.ActivityPopup;
import com.xxfc.platform.activity.vo.PopupQuery;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.*;
import tk.mybatis.mapper.entity.Example;

import java.util.List;

/**
 * 弹窗后台
 *
 * @author Administrator
 */
@RestController
@RequestMapping("activityPopupManage")
@Slf4j
public class ActivityPopupManageController extends BaseController<ActivityPopupBiz, ActivityPopup> {

    /**
     * 后台列表
     * @param query
     * @return
     */
    @PostMapping(value = "/manage/findAllByQuery")
    public ObjectRestResponse findAllByQuery(@RequestBody PopupQuery query) {
        Example example = new Example(ActivityPopup.class);
        if (StringUtils.isNotBlank(query.getPopupName())) {
            example.createCriteria().andLike("name", "%" + query.getPopupName() + "%");
        }
        PageHelper.startPage(query.getPage(), query.getLimit());
        List<ActivityPopup> activityPopups = baseBiz.selectByExample(example);
        return ObjectRestResponse.succ(PageInfo.of(activityPopups));
    }

    /**
     * 查询一条
     * @param id
     * @return
     */
    @GetMapping(value = "/manage/getOne/{id}")
    public ObjectRestResponse<ActivityPopup> getOne(@PathVariable Integer id) {
        Example exa=new Example(ActivityPopup.class);
        Example.Criteria criteria = exa.createCriteria();
        criteria.andEqualTo("isDel",0);
        criteria.andEqualTo("id",id);
        List<ActivityPopup> activityPopups = baseBiz.selectByExample(exa);
        if (activityPopups==null||activityPopups.size()==0) {
            return ObjectRestResponse.succ(new ActivityPopup());
        }
        if (activityPopups.size()>1) {
            return ObjectRestResponse.createDefaultFail();
        }
        return ObjectRestResponse.succ(activityPopups.get(0));
    }

    /**
     * 删除
     * @param id
     * @return
     */
    @DeleteMapping("manage/activity/deleteOne/{id}")
    public ObjectRestResponse deleteOne(@PathVariable  Integer id){
        baseBiz.deleteOne(id);
        return ObjectRestResponse.succ();
    }


//    /**
//     * 添加
//     * @param activityPopup
//     * @return
//     */
//    @ApiOperation("保存")
//    @PutMapping(value = "save")
//    @ResponseBody
//    public ObjectRestResponse<ActivityPopup> save(@RequestBody ActivityPopup activityPopup){
//        baseBiz.save(activityPopup);
//        return new ObjectRestResponse<ActivityPopup>();
//    }

}
