package com.xxfc.platform.summit.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xxfc.platform.summit.util.HttpRequestUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;


@Service
@Slf4j
public class WeixinService {

    /**
     * 网页
     */
    @Value("${wx.appid}")
    private String wy_appid;
    @Value("${wx.appSercet}")
    private String  wy_secret;

    @Autowired
    AccessTokenService tokenService;


    public  JSONObject getAccessToken(String code){
        String url = "https://api.weixin.qq.com/sns/oauth2/access_token?";
        String params = "appid="+wy_appid+"&secret="+wy_secret+"&code="+code+"&grant_type=authorization_code";
        String result = HttpRequestUtil.httpGet(url + params);
        JSONObject data = JSON.parseObject(result);

        return data;
    }

    public  JSONObject getValidateData(String access_token,String openid){
        String url = "https://api.weixin.qq.com/sns/auth?access_token=" + access_token + "&openid=" + openid;
        String result = HttpRequestUtil.httpGet(url);
        JSONObject data = JSON.parseObject(result);

        return data;
    }

    public  JSONObject getRefreshToken(String refresh_token){
        String url = "https://api.weixin.qq.com/sns/oauth2/refresh_token?appid=" + wy_appid + "&grant_type=refresh_token&refresh_token=" + refresh_token;
        String result = HttpRequestUtil.httpGet(url);
        JSONObject data = JSON.parseObject(result);

        return data;
    }

    public  JSONObject getUserInfo(String access_token,String openid){
        String url = "https://api.weixin.qq.com/sns/userinfo?access_token=" + access_token + "&openid=" + openid + "&lang=zh_CN";
        String result = HttpRequestUtil.httpGet(url);
        JSONObject data = JSON.parseObject(result);

        return data;
    }

    public  String getAuthorize(String redirec_url){
        String oauth_api = "https://open.weixin.qq.com/connect/oauth2/authorize?appid={APPID}&redirect_uri={REDIRECT_URI}&response_type=code&scope={SCOPE}&state={STATE}#wechat_redirect";
        oauth_api = oauth_api.replace("{APPID}", wy_appid)
                .replace("{REDIRECT_URI}", redirec_url)
                .replace("{SCOPE}", "snsapi_userinfo").replace("{STATE}", "state");
     log.info("---oauth_api===="+oauth_api);
     return oauth_api;
    }

    public  JSONObject getBaseUserInfo(String openid){
        String url = "https://api.weixin.qq.com/cgi-bin/user/info?access_token=" + tokenService.getAccessTokenStr() + "&openid=" + openid + "&lang=zh_CN";
        String result = HttpRequestUtil.httpGet(url);
        JSONObject data = JSON.parseObject(result);
        return data;
    }


}
