package com.xxfc.platform.order.contant.enumerate;

import java.util.HashMap;
import java.util.Map;

public enum RefundTypeEnum {
    ORDER_FUND(1, "订单款"),
    DEPOSIT(2, "押金"),
    ;
    /**
     * 编码
     */
    private Integer code;
    /**
     * 类型描述
     */
    private String desc;

    private static Map<Integer,String> codeAndDesc = new HashMap<Integer, String>();
            //Maps.newHashMap();

    static{
        for(RefundTypeEnum enumE : RefundTypeEnum.values()){
            codeAndDesc.put(enumE.getCode(),enumE.getDesc());
        }
    }

    RefundTypeEnum(Integer code, String desc){
        this.code=code;
        this.desc=desc;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public static Boolean exists(Integer code){
        return codeAndDesc.containsKey(code);
    }
}