package com.xxfc.platform.activity.rest;

import com.github.wxiaoqi.security.admin.feign.dto.AppUserDTO;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.xxfc.platform.activity.biz.ActivityPopupBiz;
import com.xxfc.platform.activity.entity.ActivityPopup;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 活动弹窗
 * @author Administrator
 */
@RestController
@RequestMapping("activityPopup")
public class ActivityPopupController extends ActivityBaseController<ActivityPopupBiz> {
    /**
     * 返回活动弹窗列表
     * @return
     */
    @GetMapping("/app/unauth/getActivityPopup")
    public ObjectRestResponse<List<ActivityPopup>> getActivityPopup() {
        AppUserDTO userInfo = getUserInfo();
        return ObjectRestResponse.succ(getBaseBiz().getActivityPopup(userInfo));
    }

    /**
     * 保存用户和活动弹窗关系
     * @param id
     * @return
     */
    @PostMapping("/app/unauth/setActivityPopup/{id}")
    public ObjectRestResponse<List<ActivityPopup>> setActivityPopup(@PathVariable Integer id) {
        AppUserDTO userInfo = getUserInfo();
        getBaseBiz().setActivityPopup(userInfo,id);
        return ObjectRestResponse.succ();
    }


}
