package com.xxfc.platform.order.pojo.dto;


import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;

/**
 * 门店收支明细DTO
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/12/25 14:53
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class CompanyWalletDetailV2DTO {


    @ApiModelProperty("订单号")
    private  String orderNo;


    @ApiModelProperty("是否取消订单：0-否；1-是")
    private  Integer isCanelOrder = 0;

    @ApiModelProperty("出发门店")
    private  Integer startCompanyId;


    @ApiModelProperty("结束门店")
    private  Integer endCompanyId;


    @ApiModelProperty("所属门店")
    private  Integer vehicleCompanyId;


    @ApiModelProperty("平台门店")
    private  Integer platformCompanyId;


    @ApiModelProperty("平台门店")
    private  Long platformBranchId;


    @ApiModelProperty("消费金额")
    private BigDecimal orderAmount =BigDecimal.ZERO;

    @ApiModelProperty("收车服务费")
    private BigDecimal closedVehicleAmout =BigDecimal.ZERO;


    @ApiModelProperty("不计免赔费")
    private BigDecimal damageSafeAmount =BigDecimal.ZERO;


    @ApiModelProperty("其他费用-延迟用车不记免赔")
    private BigDecimal damageSafeAmount2 =BigDecimal.ZERO;


    //算出来
    @ApiModelProperty("分销金额")
    private BigDecimal comssion =BigDecimal.ZERO;


    @ApiModelProperty("定损费")
    private BigDecimal lossSpecifiedAmount =BigDecimal.ZERO;


    @ApiModelProperty("违章费")
    private BigDecimal breakRulesRegulation =BigDecimal.ZERO;


    @ApiModelProperty("违约金")
    private BigDecimal violateAmount =BigDecimal.ZERO;


    @ApiModelProperty("更换还车公司费用")
    private BigDecimal chageAmount =BigDecimal.ZERO;


    @ApiModelProperty("订单抽成比例")
    private BigDecimal orderExtract = new BigDecimal(1);


    @ApiModelProperty("平台抽成比例")
    private BigDecimal platformExtract = new BigDecimal(1);


    //算出来
    @ApiModelProperty("车辆费用")
    private  BigDecimal vehicleAmount;

    public  BigDecimal getVehicleAmount(){
        return orderAmount.subtract(closedVehicleAmout).subtract(damageSafeAmount).subtract(comssion);
    }


    @ApiModelProperty("订单抽成")
    private  BigDecimal orderComssion;


    public  BigDecimal getOrderComssion(){
        return (getVehicleAmount().multiply(orderExtract).setScale(2, BigDecimal.ROUND_HALF_UP)).add(chageAmount);
    }


    @ApiModelProperty("平台抽成")
    private  BigDecimal platformComssion;


    public  BigDecimal getPlatformComssion(){
        return getVehicleAmount().multiply(platformExtract).setScale(2, BigDecimal.ROUND_HALF_UP);
    }


    //算出来
    @ApiModelProperty("车辆租赁费")
    private  BigDecimal rentVehicleAmount;



    public  BigDecimal getRentVehicleAmount(){
        return getVehicleAmount().subtract(getOrderComssion()).subtract(getPlatformComssion());
    }






}
