package com.xxfc.platform.order.contant.enumerate;

import cn.hutool.core.date.DateUtil;
import com.xxfc.platform.order.entity.OrderReceivedStatisticsBase;
import com.xxfc.platform.order.pojo.vo.OrderReceivedStatisticsVo;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/11/11 15:25
 */
public enum ReceivedStatisticsEnum {
    DAY(1, "按日统计") {
        @Override
        Map<Object, List<OrderReceivedStatisticsBase>> wrapMap(List<? extends OrderReceivedStatisticsBase> orderReceivedStatisticsBases) {
            if (CollectionUtils.isEmpty(orderReceivedStatisticsBases)) {
                return Collections.EMPTY_MAP;
            }
            return orderReceivedStatisticsBases.stream().peek(x -> {
                ((OrderReceivedStatisticsBase) x).setDivisor(1);
                ((OrderReceivedStatisticsBase) x).setDateStr(DateUtil.format(((OrderReceivedStatisticsBase) x).getDate(),"yyyy-MM-dd"));
            }).collect(Collectors.groupingBy(OrderReceivedStatisticsBase::getDate, Collectors.toList()));
        }
    },
    WEEK(2, "按周统计") {
        @Override
        Map<Object, List<OrderReceivedStatisticsBase>> wrapMap(List<? extends OrderReceivedStatisticsBase> orderReceivedStatisticsBases) {
            if (CollectionUtils.isEmpty(orderReceivedStatisticsBases)) {
                return Collections.EMPTY_MAP;
            }
            return orderReceivedStatisticsBases.stream().peek(x -> ((OrderReceivedStatisticsBase) x).setDivisor(7)).collect(Collectors.groupingBy(OrderReceivedStatisticsBase::getWeekOfYear, Collectors.toList()));
        }
    },
    MONTH(3, "按月统计") {
        @Override
        Map<Object, List<OrderReceivedStatisticsBase>> wrapMap(List<? extends OrderReceivedStatisticsBase> orderReceivedStatisticsBases) {
            if (CollectionUtils.isEmpty(orderReceivedStatisticsBases)) {
                return Collections.EMPTY_MAP;
            }
            return orderReceivedStatisticsBases.stream().peek(x -> {
                OrderReceivedStatisticsBase orderReceivedStatisticsBase = (OrderReceivedStatisticsBase) x;
                orderReceivedStatisticsBase.setDate(null);
                orderReceivedStatisticsBase.setWeekOfYear(null);
                LocalDate localDate = LocalDate.of(Integer.valueOf(orderReceivedStatisticsBase.getYear()),
                        Integer.valueOf(orderReceivedStatisticsBase.getMonth().replace(orderReceivedStatisticsBase.getYear(), "")), 1);
                int lastDay = localDate.with(TemporalAdjusters.lastDayOfMonth()).getDayOfMonth();
                orderReceivedStatisticsBase.setDivisor(lastDay);
            }).collect(Collectors.groupingBy(OrderReceivedStatisticsBase::getMonth, Collectors.toList()));
        }
    };
    private int wayCode;
    private String value;
    private static Map<Integer, ReceivedStatisticsEnum> statisticsEnumMap;

    static {
        statisticsEnumMap = EnumSet.allOf(ReceivedStatisticsEnum.class).stream().collect(Collectors.toMap(ReceivedStatisticsEnum::getWayCode, Function.identity()));
    }

    ReceivedStatisticsEnum(int wayCode, String value) {
        this.wayCode = wayCode;
        this.value = value;
    }

    /**
     * 统计方式
     *
     * @param orderReceivedStatisticsBases
     * @return
     */
    abstract Map<Object, List<OrderReceivedStatisticsBase>> wrapMap(List<? extends OrderReceivedStatisticsBase> orderReceivedStatisticsBases);

    public static Map<Object, List<OrderReceivedStatisticsBase>> orderstatistics(List<? extends OrderReceivedStatisticsBase> orderReceivedStatisticsBases, int wayCode) {
        ReceivedStatisticsEnum statisticsEnum = createInstance(wayCode);
        return statisticsEnum.wrapMap(orderReceivedStatisticsBases);
    }

    private static ReceivedStatisticsEnum createInstance(int wayCode) {
        return statisticsEnumMap.get(wayCode);
    }

    /**
     * 类型转换
     *
     * @param source
     * @param <T>
     * @return
     */
    public static <T> List<T> convertToTargetBean(List<? extends OrderReceivedStatisticsBase> source) {
        return source.stream().map(x -> (T) x).collect(Collectors.toList());
    }

    public static OrderReceivedStatisticsVo createOrderReceivedStatistics(OrderReceivedStatisticsBase orderReceivedStatisticsBase, BigDecimal amount, Integer quantity) {
        return OrderReceivedStatisticsVo.builder()
                .date(orderReceivedStatisticsBase.getDate())
                .month(orderReceivedStatisticsBase.getMonth())
                .weekOfYear(orderReceivedStatisticsBase.getWeekOfYear())
                .year(orderReceivedStatisticsBase.getYear())
                .orderNum(quantity)
                .dateStr(orderReceivedStatisticsBase.getDateStr())
                .orderAmount(amount)
                .build();
    }

    public int getWayCode() {
        return wayCode;
    }

    public void setWayCode(int wayCode) {
        this.wayCode = wayCode;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }
}
