package com.xxfc.platform.order.contant.enumerate;

import com.xxfc.platform.order.entity.OrderMemberReceivedStatistics;
import com.xxfc.platform.order.entity.OrderReceivedStatisticsBase;
import com.xxfc.platform.order.pojo.vo.OrderReceivedStatisticsVo;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.*;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/11/11 10:36
 */
public enum  OrderMemberReceivedStatisticsSignEnum{
    MEMBER_TOTAL_AMOUNT("da_mta","会员订单总额"){
        @Override
        Map<String, List<OrderReceivedStatisticsVo>> wrapToMap(Map<Object,List<OrderReceivedStatisticsBase>> orderMap) {
            Map<String, List<OrderReceivedStatisticsVo>> resultMap = new HashMap<>();
            List<OrderReceivedStatisticsVo> orderReceivedStatisticsVos = new ArrayList<>();
            orderMap.forEach((K,V)->{
                List<OrderMemberReceivedStatistics> orderMemberReceivedStatisticsList = ReceivedStatisticsEnum.convertToTargetBean(V);
                BigDecimal totalAmount = orderMemberReceivedStatisticsList.stream().map(x -> x.getTotalAmount()).reduce(BigDecimal.ZERO, (x, y) -> x.add(y));
                OrderMemberReceivedStatistics orderMemberReceivedStatistics = orderMemberReceivedStatisticsList.get(0);
                OrderReceivedStatisticsVo receivedStatisticsVo = ReceivedStatisticsEnum.createOrderReceivedStatistics(orderMemberReceivedStatistics,totalAmount,null);
                orderReceivedStatisticsVos.add(receivedStatisticsVo);
            });
             resultMap.put(getSign(),orderReceivedStatisticsVos);
            return resultMap;
        }
    },
    COMMON__MEMBER_TOTAL_AMOUNT("db_cmta","普通会员订单总额"){
        @Override
        Map<String, List<OrderReceivedStatisticsVo>> wrapToMap(Map<Object, List<OrderReceivedStatisticsBase>> orderMap) {
            Map<String, List<OrderReceivedStatisticsVo>> resultMap = new HashMap<>();
            List<OrderReceivedStatisticsVo> orderReceivedStatisticsVos = new ArrayList<>();
            orderMap.forEach((K,V)->{
                List<OrderMemberReceivedStatistics> orderMemberReceivedStatisticsList = ReceivedStatisticsEnum.convertToTargetBean(V);
                BigDecimal totalAmount = orderMemberReceivedStatisticsList.stream().map(x -> x.getToalCommonAmmount()).reduce(BigDecimal.ZERO, (x, y) -> x.add(y));
                OrderMemberReceivedStatistics orderMemberReceivedStatistics = orderMemberReceivedStatisticsList.get(0);
                OrderReceivedStatisticsVo receivedStatisticsVo = ReceivedStatisticsEnum.createOrderReceivedStatistics(orderMemberReceivedStatistics,totalAmount,null);
                orderReceivedStatisticsVos.add(receivedStatisticsVo);
            });
            resultMap.put(getSign(),orderReceivedStatisticsVos);
            return resultMap;
        }
    },
    MEMBER_TOTAL_QUANTITY("dc_cmtq","普通会员订单量"){
        @Override
        Map<String, List<OrderReceivedStatisticsVo>> wrapToMap(Map<Object, List<OrderReceivedStatisticsBase>> orderMap) {
            Map<String, List<OrderReceivedStatisticsVo>> resultMap = new HashMap<>();
            List<OrderReceivedStatisticsVo> orderReceivedStatisticsVos = new ArrayList<>();
            orderMap.forEach((K,V)->{
                List<OrderMemberReceivedStatistics> orderMemberReceivedStatisticsList = V.stream().map(x -> (OrderMemberReceivedStatistics) x).collect(Collectors.toList());
                Integer totalQuantity = orderMemberReceivedStatisticsList.stream().map(x -> x.getTotalCommonQuantity()).reduce(0, (x, y) -> x+y);
                OrderMemberReceivedStatistics orderMemberReceivedStatistics = orderMemberReceivedStatisticsList.get(0);
                OrderReceivedStatisticsVo receivedStatisticsVo = ReceivedStatisticsEnum.createOrderReceivedStatistics(orderMemberReceivedStatistics,null,totalQuantity);
                orderReceivedStatisticsVos.add(receivedStatisticsVo);
            });
            resultMap.put(getSign(),orderReceivedStatisticsVos);
            return resultMap;
        }
    },
    GOLD_MEMBER_TOTAL_AMOUNT("dd_gmta","黄金会员订单总额"){
        @Override
        Map<String, List<OrderReceivedStatisticsVo>> wrapToMap(Map<Object, List<OrderReceivedStatisticsBase>> orderMap) {
            Map<String, List<OrderReceivedStatisticsVo>> resultMap = new HashMap<>();
            List<OrderReceivedStatisticsVo> orderReceivedStatisticsVos = new ArrayList<>();
            orderMap.forEach((K,V)->{
                List<OrderMemberReceivedStatistics> orderMemberReceivedStatisticsList = ReceivedStatisticsEnum.convertToTargetBean(V);
                BigDecimal totalAmount = orderMemberReceivedStatisticsList.stream().map(x -> x.getTotalGoldAmount()).reduce(BigDecimal.ZERO, (x, y) -> x.add(y));
                OrderMemberReceivedStatistics orderMemberReceivedStatistics = orderMemberReceivedStatisticsList.get(0);
                OrderReceivedStatisticsVo receivedStatisticsVo = ReceivedStatisticsEnum.createOrderReceivedStatistics(orderMemberReceivedStatistics,totalAmount,null);
                orderReceivedStatisticsVos.add(receivedStatisticsVo);
            });
            resultMap.put(getSign(),orderReceivedStatisticsVos);
            return resultMap;
        }
    },
    GOLD_MEMBER_TOTAL_QUANTITY("de_mgtq","黄金会员订单量"){
        @Override
        Map<String, List<OrderReceivedStatisticsVo>> wrapToMap(Map<Object, List<OrderReceivedStatisticsBase>> orderMap) {
            Map<String, List<OrderReceivedStatisticsVo>> resultMap = new HashMap<>();
            List<OrderReceivedStatisticsVo> orderReceivedStatisticsVos = new ArrayList<>();
            orderMap.forEach((K,V)->{
                List<OrderMemberReceivedStatistics> orderMemberReceivedStatisticsList = ReceivedStatisticsEnum.convertToTargetBean(V);
                Integer totalQuantity = orderMemberReceivedStatisticsList.stream().map(x -> x.getTotalGoldQuantity()).reduce(0, (x, y) -> x+y);
                OrderMemberReceivedStatistics orderMemberReceivedStatistics = orderMemberReceivedStatisticsList.get(0);
                OrderReceivedStatisticsVo receivedStatisticsVo = ReceivedStatisticsEnum.createOrderReceivedStatistics(orderMemberReceivedStatistics,null,totalQuantity);
                orderReceivedStatisticsVos.add(receivedStatisticsVo);
            });
            resultMap.put(getSign(),orderReceivedStatisticsVos);
            return resultMap;
        }
    },
    DIAMOND_MEMBER_TOTAL_AMOUNT("df_dmta","钻石会员订单总额"){
        @Override
        Map<String, List<OrderReceivedStatisticsVo>> wrapToMap(Map<Object, List<OrderReceivedStatisticsBase>> orderMap) {
            Map<String, List<OrderReceivedStatisticsVo>> resultMap = new HashMap<>();
            List<OrderReceivedStatisticsVo> orderReceivedStatisticsVos = new ArrayList<>();
            orderMap.forEach((K,V)->{
                List<OrderMemberReceivedStatistics> orderMemberReceivedStatisticsList = ReceivedStatisticsEnum.convertToTargetBean(V);
                BigDecimal totalAmount = orderMemberReceivedStatisticsList.stream().map(x -> x.getTotalDiamondAmmount()).reduce(BigDecimal.ZERO, (x, y) -> x.add(y));
                OrderMemberReceivedStatistics orderMemberReceivedStatistics = orderMemberReceivedStatisticsList.get(0);
                OrderReceivedStatisticsVo receivedStatisticsVo = ReceivedStatisticsEnum.createOrderReceivedStatistics(orderMemberReceivedStatistics,totalAmount,null);
                orderReceivedStatisticsVos.add(receivedStatisticsVo);
            });
            resultMap.put(getSign(),orderReceivedStatisticsVos);
            return resultMap;
        }
    },
    DIAMOND_MEMBER_TOTAL_QUANTITY("dg_dmtq","钻石会员订单量"){
        @Override
        Map<String, List<OrderReceivedStatisticsVo>> wrapToMap(Map<Object, List<OrderReceivedStatisticsBase>> orderMap) {
            Map<String, List<OrderReceivedStatisticsVo>> resultMap = new HashMap<>();
            List<OrderReceivedStatisticsVo> orderReceivedStatisticsVos = new ArrayList<>();
            orderMap.forEach((K,V)->{
                List<OrderMemberReceivedStatistics> orderMemberReceivedStatisticsList = ReceivedStatisticsEnum.convertToTargetBean(V);
                Integer totalQuantity = orderMemberReceivedStatisticsList.stream().map(x -> x.getTotalDiamondQuantity()).reduce(0, (x, y) -> x+y);
                OrderMemberReceivedStatistics orderMemberReceivedStatistics = orderMemberReceivedStatisticsList.get(0);
                OrderReceivedStatisticsVo receivedStatisticsVo = ReceivedStatisticsEnum.createOrderReceivedStatistics(orderMemberReceivedStatistics,null,totalQuantity);
                orderReceivedStatisticsVos.add(receivedStatisticsVo);
            });
            resultMap.put(getSign(),orderReceivedStatisticsVos);
            return resultMap;
        }
    },
    MEMBER_AVG_AMOUNT("dh_mavga","会员订单金额arpu"){
        @Override
        Map<String, List<OrderReceivedStatisticsVo>> wrapToMap(Map<Object,List<OrderReceivedStatisticsBase>> orderMap) {
            Map<String, List<OrderReceivedStatisticsVo>> resultMap = new HashMap<>();
            List<OrderReceivedStatisticsVo> orderReceivedStatisticsVos = new ArrayList<>();
            AtomicReference<Integer> divisorAtomicReference = new AtomicReference<>();
            orderMap.forEach((K,V)->{
                List<OrderMemberReceivedStatistics> orderMemberReceivedStatisticsList = ReceivedStatisticsEnum.convertToTargetBean(V);
                Integer divisor = divisorAtomicReference.get();
                if (Objects.isNull(divisor)){
                    divisor = orderMemberReceivedStatisticsList.get(0).getDivisor();
                    divisorAtomicReference.set(divisor);
                }
                BigDecimal avgAmount = orderMemberReceivedStatisticsList.stream().map(x -> x.getTotalAmount()).reduce(BigDecimal.ZERO,BigDecimal::add).divide(new BigDecimal(divisor),2, RoundingMode.HALF_UP);
                OrderMemberReceivedStatistics orderMemberReceivedStatistics = orderMemberReceivedStatisticsList.get(0);
                OrderReceivedStatisticsVo receivedStatisticsVo = ReceivedStatisticsEnum.createOrderReceivedStatistics(orderMemberReceivedStatistics,avgAmount,null);
                orderReceivedStatisticsVos.add(receivedStatisticsVo);
            });
            resultMap.put(getSign(),orderReceivedStatisticsVos);
            return resultMap;
        }
    };
    private String sign;
    private String desc;
    private static  Map<String,OrderMemberReceivedStatisticsSignEnum> orderMemberReceivedStatisticsSignEnumMap;

     static {
         orderMemberReceivedStatisticsSignEnumMap = EnumSet.allOf(OrderMemberReceivedStatisticsSignEnum.class).stream().collect(Collectors.toMap(OrderMemberReceivedStatisticsSignEnum::getSign, Function.identity()));
     }
    OrderMemberReceivedStatisticsSignEnum(String sign, String desc) {
        this.sign = sign;
        this.desc = desc;
    }
    /**
     * 统计项
     * @param orderMap
     * @return
     */
    abstract Map<String, List<OrderReceivedStatisticsVo>> wrapToMap(Map<Object,List<OrderReceivedStatisticsBase>> orderMap);

    public static Map<String, List<OrderReceivedStatisticsVo>> orderMemberstatisticsMap(Map<Object, List<OrderReceivedStatisticsBase>> orderMemberstatisticsMap, List<String> signs) {
         Map<String,List<OrderReceivedStatisticsVo>> resultMap = new HashMap<>(signs.size());
        for (String sign : signs) {
            OrderMemberReceivedStatisticsSignEnum orderMemberReceivedStatisticsSignEnum = orderMemberReceivedStatisticsSignEnumMap.get(sign);
            Map<String, List<OrderReceivedStatisticsVo>> wrapToMap = orderMemberReceivedStatisticsSignEnum.wrapToMap(orderMemberstatisticsMap);
            resultMap.putAll(wrapToMap);
        }
        return resultMap;
    }
    public String getSign() {
        return sign;
    }

    public void setSign(String sign) {
        this.sign = sign;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }


}
