package com.xxfc.platform.order.contant.enumerate;

import java.util.HashMap;
import java.util.Map;

public enum CompanyWalletSourceEnum {
    CLOSED_VEHICLE(1, "收车服务费"),
    DAMAGE_SAFE(2, "不计免赔费"),
    RENT_VEHICLE(3, "车辆租赁费"),
    ORDER_COMSSION(4, "订单抽成"),
    PLATFORM_COMSSION(5, "平台抽成"),
    LOSS_SPECIFIED(6, "定损费"),
    BREAK_RULES_REGULATION(7, "违章费"),
    VIOLATE_AMOUNT(8, "违约金"),
    ;
    /**
     * 编码
     */
    private Integer code;
    /**
     * 类型描述
     */
    private String desc;

    public static Map<Integer, CompanyWalletSourceEnum> codeAndDesc = new HashMap<Integer, CompanyWalletSourceEnum>();
            //Maps.newHashMap();

    static{
        for(CompanyWalletSourceEnum enumE : CompanyWalletSourceEnum.values()){
            codeAndDesc.put(enumE.getCode(), enumE);
        }
    }

    CompanyWalletSourceEnum(Integer code, String desc){
        this.code=code;
        this.desc=desc;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public static Boolean exists(Integer code){
        return codeAndDesc.containsKey(code);
    }

    public static CompanyWalletSourceEnum get(Integer code) {
        for(CompanyWalletSourceEnum enumE : CompanyWalletSourceEnum.values()) {
            if (enumE.getCode().equals(code)) {
                return enumE;
            }
        }
        return null;
    }
}