package com.xxfc.platform.im.rest;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.xxfc.platform.im.biz.CustomerServiceBiz;
import com.xxfc.platform.im.biz.CustomerServiceMGBiz;
import com.xxfc.platform.im.vo.CustomerServiceVO;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/9/5 10:31
 */
@RestController
@RequiredArgsConstructor(onConstructor = @__(@Autowired))
@RequestMapping("/app/unauth/customer_service")
public class CustomerServiceController {
     private final CustomerServiceMGBiz customerServiceMGBiz;
     private final CustomerServiceBiz customerServiceBiz;

     @GetMapping("/list")
     public ObjectRestResponse<List<CustomerServiceVO>> findAll(){
//           List<CustomerServiceVO> customerServiceVOS = customerServiceMGBiz.findAll();
           List<CustomerServiceVO> customerServiceVOS = customerServiceBiz.findAll();
         return ObjectRestResponse.succ(customerServiceVOS);
     }

     @GetMapping("/{id}")
     public ObjectRestResponse<CustomerServiceVO> findById(@PathVariable(value = "id") Long id){
//         CustomerServiceVO customerServiceVO = customerServiceMGBiz.findById(id);
         CustomerServiceVO customerServiceVO = customerServiceBiz.findById(id);
         return ObjectRestResponse.succ(customerServiceVO);
     }

}
