package com.xxfc.platform.activity.bo;

import com.xxfc.platform.activity.vo.ActivityAttendanceRecordTotalVo;
import com.xxfc.platform.activity.vo.ActivityAttendanceRecordVo;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.apache.commons.collections4.CollectionUtils;

import java.util.Collections;
import java.util.List;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/12/4 15:19
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class ActivityAttendanceRecordBo {

    private Integer totalPage;
    private Long totalCount;
    private Integer pageNum;
    private Integer pageSize;
    private List<ActivityAttendanceRecordVo> activityAttendanceRecordVos;
    private ActivityAttendanceRecordTotalVo activityAttendanceRecordTotalVo;

    public Integer getTotalPage() {
        return totalPage==null?0:totalPage;
    }

    public Long getTotalCount() {
        return totalCount==null?0:totalCount;
    }

    public Integer getPageNum() {
        return pageNum==null?1:pageNum;
    }

    public Integer getPageSize() {
        return pageSize==null?0:pageSize;
    }

    public List<ActivityAttendanceRecordVo> getActivityAttendanceRecordVos() {
        return CollectionUtils.isEmpty(activityAttendanceRecordVos)? Collections.EMPTY_LIST:activityAttendanceRecordVos;
    }

    public ActivityAttendanceRecordTotalVo getActivityAttendanceRecordTotalVo() {
        return activityAttendanceRecordTotalVo==null?new ActivityAttendanceRecordTotalVo():activityAttendanceRecordTotalVo;
    }
}
