package com.github.wxiaoqi.security.admin.util;

import org.joda.time.DateTime;

import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/10/23 10:52
 */
public class DateUtils {

    public static LocalDate dateToLocalDate(Date date) {
        return LocalDate.from(date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate());
    }

    public static Date localDateToDate(LocalDate localDate) {
        return Date.from(localDate.atStartOfDay(ZoneId.systemDefault()).toInstant());
    }

    /**
     * 获取当天的开始时间
     * @return
     */
    public static long getStartOfDay() {
        return getStartOfDay(new Date());
    }

    /**
     * 获取某天的开始时间
     * @param date
     * @return
     */
    public static long getStartOfDay(Date date) {
        DateTime dateTime = new DateTime(date);
        DateTime startOfDay = dateTime.withTimeAtStartOfDay();
        return startOfDay.getMillis();
    }

    /**
     * 获取当天的结束时间
     * @return
     */
    public static long getEndOfDay() {
        return getEndOfDay(new Date());
    }

    /**
     * 获取某天的结束时间
     * @param date
     * @return
     */
    public static long getEndOfDay(Date date) {
        DateTime dateTime = new DateTime(date);
        DateTime endOfDay = dateTime.millisOfDay().withMaximumValue();
        return endOfDay.getMillis();
    }

}
