package com.xxfc.platform.universal.service;

import com.alibaba.fastjson.JSONObject;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.dysmsapi.model.v20170525.SendSmsRequest;
import com.aliyuncs.dysmsapi.model.v20170525.SendSmsResponse;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.github.wxiaoqi.security.common.util.RandomUtil;
import com.github.wxiaoqi.security.common.util.process.SystemConfig;
import com.github.wxiaoqi.security.common.util.result.JsonResultUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;


@Service
@Slf4j
public class SmsService {
    //产品名称:云通信短信API产品,开发者无需替换
    static final String product = "Dysmsapi";
    //产品域名,开发者无需替换
    static final String domain = "dysmsapi.aliyuncs.com";

    // TODO 此处需要替换成开发者自己的AK(在阿里云访问控制台寻找)
    static final String accessKeyId = SystemConfig.ACCESSKEYID;
    static final String accessKeySecret = SystemConfig.ACCESSKEYSECRET;
    //签名
    static final String SignName = SystemConfig.SIGNNAME;
    //短信模板id
    static final String TemplateCode = SystemConfig.TEMPLATECODE;
    static final String TemplateParam="{\"code\":\"str\"}";
    static final String param = "param";


   public JSONObject  smsCode(String mobile){
       String code = RandomUtil.getRandomStr(6);// 6位短信验证码
       try {
           if(StringUtils.isNotBlank(mobile)){
               mobile=mobile.replace(" ", "");
           }
           code=sendSms(mobile,code);
           return JsonResultUtil.createSuccessResultWithObj(code);
       } catch (ClientException e) {
           e.printStackTrace();
           return JsonResultUtil.createDefaultFail();
       }
   }

    public JSONObject  smsByCode(String mobile,String pwd,String templateCode){
        try {
            if(StringUtils.isNotBlank(mobile)){
                mobile=mobile.replace(" ", "");
            }
            sendSmsByStr(mobile,pwd,templateCode);
            return JsonResultUtil.createSuccessResult();
        } catch (ClientException e) {
            e.printStackTrace();
            return JsonResultUtil.createDefaultFail();
        }
    }
    public String sendSms(String mobile, String code) throws ClientException {

        //可自助调整超时时间
        System.setProperty("sun.net.client.defaultConnectTimeout", "10000");
        System.setProperty("sun.net.client.defaultReadTimeout", "10000");

        //初始化acsClient,暂不支持region化
        IClientProfile profile = DefaultProfile.getProfile("cn-hangzhou", accessKeyId, accessKeySecret);
        DefaultProfile.addEndpoint("cn-hangzhou", "cn-hangzhou", product, domain);
        IAcsClient acsClient = new DefaultAcsClient(profile);

        //组装请求对象-具体描述见控制台-文档部分内容
        SendSmsRequest request = new SendSmsRequest();
        //必填:待发送手机号
        request.setPhoneNumbers(mobile);
        //必填:短信签名-可在短信控制台中找到
        request.setSignName(SignName);
        //必填:短信模板-可在短信控制台中找到
        request.setTemplateCode(TemplateCode);
        //可选:模板中的变量替换JSON串,如模板内容为"亲爱的${name},您的验证码为${code}"时,此处的值为

        request.setTemplateParam(TemplateParam.replace("str",code));//\"name\":\"Tom\",

        //选填-上行短信扩展码(无特殊需求用户请忽略此字段)
        //request.setSmsUpExtendCode("90997");

        //可选:outId为提供给业务方扩展字段,最终在短信回执消息中将此值带回给调用者
        //request.setOutId("yourOutId");
        //hint 此处可能会抛出异常，注意catch
        SendSmsResponse sendSmsResponse = acsClient.getAcsResponse(request);
        log.info("短信接口返回的数据----------------mobile======"+mobile+"----code===="+code);
        log.info("Code=" + sendSmsResponse.getCode());
        log.info("Message=" + sendSmsResponse.getMessage());
        log.info("RequestId=" + sendSmsResponse.getRequestId());
        log.info("BizId=" + sendSmsResponse.getBizId());
        if(sendSmsResponse.getCode() != null && sendSmsResponse.getCode().equals("OK")) {
            //请求成功
            return  code;
        }

        return null;
    }

    public boolean sendSmsByStr(String mobile, String str,String templateCode) throws ClientException {

        //可自助调整超时时间
        System.setProperty("sun.net.client.defaultConnectTimeout", "10000");
        System.setProperty("sun.net.client.defaultReadTimeout", "10000");

        //初始化acsClient,暂不支持region化
        IClientProfile profile = DefaultProfile.getProfile("cn-hangzhou", accessKeyId, accessKeySecret);
        DefaultProfile.addEndpoint("cn-hangzhou", "cn-hangzhou", product, domain);
        IAcsClient acsClient = new DefaultAcsClient(profile);

        //组装请求对象-具体描述见控制台-文档部分内容
        SendSmsRequest request = new SendSmsRequest();
        //必填:待发送手机号
        request.setPhoneNumbers(mobile);
        //必填:短信签名-可在短信控制台中找到
        request.setSignName(SignName);
        //必填:短信模板-可在短信控制台中找到
        request.setTemplateCode(templateCode);
        //可选:模板中的变量替换JSON串,如模板内容为"亲爱的${name},您的验证码为${code}"时,此处的值为

        request.setTemplateParam(TemplateParam.replace("str",str));//\"name\":\"Tom\",

        //选填-上行短信扩展码(无特殊需求用户请忽略此字段)
        //request.setSmsUpExtendCode("90997");

        //可选:outId为提供给业务方扩展字段,最终在短信回执消息中将此值带回给调用者
        //request.setOutId("yourOutId");
        //hint 此处可能会抛出异常，注意catch
        SendSmsResponse sendSmsResponse = acsClient.getAcsResponse(request);
        log.info("短信接口返回的数据----------------mobile======"+mobile+"----str===="+str);
        log.info("Code=" + sendSmsResponse.getCode());
        log.info("Message=" + sendSmsResponse.getMessage());
        log.info("RequestId=" + sendSmsResponse.getRequestId());
        log.info("BizId=" + sendSmsResponse.getBizId());
        if(sendSmsResponse.getCode() != null && sendSmsResponse.getCode().equals("OK")) {
            //请求成功
            return  true;
        }

        return false;
    }

    public static  boolean sendTemplate(String PhoneNumbers,String params,String templateCode) throws ClientException {

        //可自助调整超时时间
        System.setProperty("sun.net.client.defaultConnectTimeout", "10000");
        System.setProperty("sun.net.client.defaultReadTimeout", "10000");

        //初始化acsClient,暂不支持region化
        IClientProfile profile = DefaultProfile.getProfile("cn-hangzhou", accessKeyId, accessKeySecret);
        DefaultProfile.addEndpoint("cn-hangzhou", "cn-hangzhou", product, domain);
        IAcsClient acsClient = new DefaultAcsClient(profile);

        //组装请求对象
        SendSmsRequest  request = new SendSmsRequest ();
        //必填:待发送手机号。支持JSON格式的批量调用，批量上限为100个手机号码,批量调用相对于单条调用及时性稍有延迟,验证码类型的短信推荐使用单条调用的方式
        request.setPhoneNumbers(PhoneNumbers);
        //必填:短信签名-可在短信控制台中找到
        request.setSignName(SignName);
        //必填:短信模板-可在短信控制台中找到
        request.setTemplateCode(templateCode);
        //可选:模板中的变量替换JSON串,如模板内容为"亲爱的${name},您的验证码为${code}"时,此处的值为

        request.setTemplateParam(params);//\"name\":\"Tom\",

        //选填-上行短信扩展码(无特殊需求用户请忽略此字段)
        //request.setSmsUpExtendCode("90997");

        //可选:outId为提供给业务方扩展字段,最终在短信回执消息中将此值带回给调用者
        //request.setOutId("yourOutId");
        //hint 此处可能会抛出异常，注意catch
        SendSmsResponse  sendSmsResponse = acsClient.getAcsResponse(request);
        log.info("短信接口返回的数据----------------mobile======"+PhoneNumbers+"----templateParam===="+params);
        log.info("Code=" + sendSmsResponse.getCode());
        log.info("Message=" + sendSmsResponse.getMessage());
        log.info("RequestId=" + sendSmsResponse.getRequestId());
        log.info("BizId=" + sendSmsResponse.getBizId());
        if(sendSmsResponse.getCode() != null && sendSmsResponse.getCode().equals("OK")) {
            //请求成功
            return  true;
        }

        return false;
    }

    public  static  void  sendTemplateToJson(String PhoneNumbers,String[] params,String templateCode){
       try {
           JSONObject jsonParams=new JSONObject();
           for (int i=0;i<params.length;i++){
               String para=params[i];
               if (para.contains("【")){
                   para=para.replaceAll("【","");
               }
               if (para.contains("】")){
                   para=para.replaceAll("】","");
               }
               jsonParams.put(param+(i+1),para);
           }
           sendTemplate(PhoneNumbers,jsonParams.toJSONString(),templateCode);
       }catch (Exception e){
           e.printStackTrace();
       }

    }

    public static void main(String[] args) throws ClientException, InterruptedException {
        SmsService smsService=new SmsService();
        //发短信
        String[] params={"1","2","3","2019-08-29","【松山湖】"};
        SmsService.sendTemplateToJson("13612688539,13265487972",params,"SMS_169904346");
        /*System.out.println("短信接口返回的数据----------------");
        System.out.println("Code=" + response.getCode());
        System.out.println("Message=" + response.getMessage());
        System.out.println("RequestId=" + response.getRequestId());
        System.out.println("BizId=" + response.getBizId());*//*

        Thread.sleep(3000L);
/*
        //查明细
        if(response.getCode() != null && response.getCode().equals("OK")) {
            QuerySendDetailsResponse querySendDetailsResponse = querySendDetails(response.getBizId());
            System.out.println("短信明细查询接口返回数据----------------");
            System.out.println("Code=" + querySendDetailsResponse.getCode());
            System.out.println("Message=" + querySendDetailsResponse.getMessage());
            int i = 0;
            for(QuerySendDetailsResponse.SmsSendDetailDTO smsSendDetailDTO : querySendDetailsResponse.getSmsSendDetailDTOs())
            {
                System.out.println("SmsSendDetailDTO["+i+"]:");
                System.out.println("Content=" + smsSendDetailDTO.getContent());
                System.out.println("ErrCode=" + smsSendDetailDTO.getErrCode());
                System.out.println("OutId=" + smsSendDetailDTO.getOutId());
                System.out.println("PhoneNum=" + smsSendDetailDTO.getPhoneNum());
                System.out.println("ReceiveDate=" + smsSendDetailDTO.getReceiveDate());
                System.out.println("SendDate=" + smsSendDetailDTO.getSendDate());
                System.out.println("SendStatus=" + smsSendDetailDTO.getSendStatus());
                System.out.println("Template=" + smsSendDetailDTO.getTemplateCode());
            }
            System.out.println("TotalCount=" + querySendDetailsResponse.getTotalCount());
            System.out.println("RequestId=" + querySendDetailsResponse.getRequestId());
        }*/

    }

}
