package com.xxfc.platform.uccn.entity;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;


/**
 * 峰会活动
 *
 * @author libin
 * @email 18178966185@163.com
 * @date 2019-08-26 15:25:32
 */
@Data
@Table(name = "summit_activity")
public class SummitActivity implements Serializable {
    private static final long serialVersionUID = 1L;

    @Id
    @GeneratedValue(generator = "JDBC")
    private Integer id;

    /**
     * 活动主标题
     */
    @Column(name = "title")
    @ApiModelProperty(value = "活动主标题")
    private String title;

    /**
     * 副标题（不展示）
     */
    @Column(name = "subtitle")
    @ApiModelProperty(value = "副标题（不展示）")
    private String subtitle;

    /**
     * 活动主图
     */
    @Column(name = "banner")
    @ApiModelProperty(value = "活动主图")
    private String banner;

    /**
     * 开始时间
     */
    @Column(name = "start_time")
    @ApiModelProperty(value = "开始时间")
    private Long startTime;

    /**
     * 结束时间
     */
    @Column(name = "end_time")
    @ApiModelProperty(value = "结束时间")
    private Long endTime;

    /**
     * 报名截止时间（不展示）
     */
    @Column(name = "reg_close_time")
    @ApiModelProperty(value = "报名截止时间（不展示）")
    private Long regCloseTime;

    /**
     * 省编码
     */
    @Column(name = "province_code")
    @ApiModelProperty(value = "省编码")
    private Integer provinceCode;

    /**
     * 省
     */
    @Column(name = "province")
    @ApiModelProperty(value = "省")
    private String province;

    /**
     * 市编码
     */
    @Column(name = "city_code")
    @ApiModelProperty(value = "市编码")
    private Integer cityCode;

    /**
     * 市
     */
    @Column(name = "city")
    @ApiModelProperty(value = "市")
    private String city;

    /**
     * 县/镇 编码
     */
    @Column(name = "town_code")
    @ApiModelProperty(value = "县/镇 编码")
    private Integer townCode;

    /**
     * 县/镇
     */
    @Column(name = "town")
    @ApiModelProperty(value = "县/镇")
    private String town;

    /**
     * 活动场地（地址格式）
     */
    @Column(name = "address")
    @ApiModelProperty(value = "活动场地（地址格式）")
    private String address;

    /**
     * 纬度（不展示）
     */
    @Column(name = "latitude")
    @ApiModelProperty(value = "纬度（不展示）")
    private BigDecimal latitude;

    /**
     * 经度 （不展示）
     */
    @Column(name = "longitude")
    @ApiModelProperty(value = "经度 （不展示）")
    private BigDecimal longitude;

    /**
     * 总人数
     */
    @Column(name = "limit_num")
    @ApiModelProperty(value = "总人数")
    private Integer limitNum;

    /**
     * 活动图文内容
     */
    @Column(name = "content")
    @ApiModelProperty(value = "活动图文内容")
    private String content;

    /**
     * 活动开关（1开，0关）
     */
    @Column(name = "is_show")
    @ApiModelProperty(value = "活动开关（0关，1开）")
    private Integer isShow;

    /**
     * 报名开关（0开，1关）
     */
    @Column(name = "is_open_reg")
    @ApiModelProperty(value = "报名开关（0开，1关）")
    private Integer isOpenReg;

    /**
     * 删除（0正常，1删除）
     */
    @Column(name = "is_del")
    @ApiModelProperty(value = "删除（0正常，1删除）")
    private Integer isDel;

    /**
     * 0是未发布，1是已发布
     */
    @Column(name = "is_publish")
    @ApiModelProperty(value = "0是未发布，1是已发布")
    private Integer isPublish;

    /**
     * 0是普通，1是置顶（首页展示）
     */
    @Column(name = "is_home_page")
    @ApiModelProperty(value = "0是普通，1是置顶（首页展示）")
    private Integer isHomePage;

    /**
     * 创建人id
     */
    @Column(name = "crt_user")
    @ApiModelProperty(value = "创建人id")
    private Integer crtUser;

    /**
     * 创建人姓名
     */
    @Column(name = "crt_name")
    @ApiModelProperty(value = "创建人姓名")
    private String crtName;

    /**
     * 创建时间
     */
    @Column(name = "crt_time")
    @ApiModelProperty(value = "创建时间", hidden = true)
    private Long crtTime;

    @Column(name = "upd_time")
    @ApiModelProperty(value = "更新时间")
    private Long updTime;

    /**
     * 活动对象说明（不展示）
     */
    @Column(name = "act_desc")
    @ApiModelProperty(value = "活动对象说明（不展示）")
    private String actDesc;

    /**
     * 活动类型(保留，不展示)
     */
    @Column(name = "type")
    @ApiModelProperty(value = "活动类型(保留，不展示)")
    private Integer type;

    /**
     * 报名人数（不展示）
     */
    @Column(name = "will_num")
    @ApiModelProperty(value = "报名人数（不展示）")
    private Integer willNum;

    /**
     * 1:欣欣官网 2：滴房车官网 0：无限制
     */
    @Column(name = "location")
    @ApiModelProperty(value = "1:欣欣官网 2：滴房车官网 0：无限制")
    private Integer location;

    /**
     * 排序
     */
    @Column(name = "rank")
    @ApiModelProperty(value = "排序")
    private Integer rank;

}
