package com.xxfc.platform.order.biz;

import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.xxfc.platform.order.entity.OrderStatistics;
import com.xxfc.platform.order.mapper.OrderStatisticsMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Objects;


/**
 * @author Administrator
 */
@Service
public class OrderStatisticsBiz extends BaseBiz<OrderStatisticsMapper, OrderStatistics> {
    @Autowired
    private DailyVehicleOrderStatisticsBiz vehicleBiz;


    @Autowired
    private DailyTravelOrderStatisticsBiz TravelBiz;

    @Autowired
    private DailyMembersOrderStatisticsBiz membersBiz;

    public OrderStatistics getTotalOrder(Integer companyId) {
        OrderStatistics result = new OrderStatistics();
        ArrayList<OrderStatistics> orderStatistics = new ArrayList<>();

        OrderStatistics vehicle = vehicleBiz.findAll(companyId);
        if (vehicle != null) {
            orderStatistics.add(vehicle);
        }
        OrderStatistics tour = TravelBiz.findAll(companyId);

        if (vehicle != null) {
            orderStatistics.add(tour);
        }
        OrderStatistics member = membersBiz.findAll(companyId);
        if (vehicle != null) {
            orderStatistics.add(member);
        }

        result.setTotalGmv(orderStatistics.stream().map(OrderStatistics::getTotalGmv).filter(o-> Objects.nonNull(o)).reduce(BigDecimal.ZERO, BigDecimal::add));

        result.setTotalForfeit(orderStatistics.stream().map(OrderStatistics::getTotalForfeit).filter(o-> Objects.nonNull(o)).reduce(BigDecimal.ZERO, BigDecimal::add));

        result.setTotalCompensation(orderStatistics.stream().map(OrderStatistics::getTotalCompensation).filter(o-> Objects.nonNull(o)).reduce(BigDecimal.ZERO, BigDecimal::add));

        result.setTotalRefundSecurityDeposit(orderStatistics.stream().map(OrderStatistics::getTotalRefundSecurityDeposit).filter(o-> Objects.nonNull(o)).reduce(BigDecimal.ZERO, BigDecimal::add));

        result.setTotalSecurityDeposit(orderStatistics.stream().map(OrderStatistics::getTotalSecurityDeposit).filter(o-> Objects.nonNull(o)).reduce(BigDecimal.ZERO, BigDecimal::add));

        result.setTotalPenalSum(orderStatistics.stream().map(OrderStatistics::getTotalPenalSum).filter(o-> Objects.nonNull(o)).reduce(BigDecimal.ZERO, BigDecimal::add));

        result.setTotalPostpone(orderStatistics.stream().map(OrderStatistics::getTotalPostpone).filter(o-> Objects.nonNull(o)).reduce(BigDecimal.ZERO, BigDecimal::add));

        return result;
    }

}
