/*
 * Decompiled with CFR 0.152.
 */
package ytx.org.apache.http.impl;

import ytx.org.apache.http.ConnectionReuseStrategy;
import ytx.org.apache.http.Header;
import ytx.org.apache.http.HeaderIterator;
import ytx.org.apache.http.HttpResponse;
import ytx.org.apache.http.HttpVersion;
import ytx.org.apache.http.ParseException;
import ytx.org.apache.http.ProtocolVersion;
import ytx.org.apache.http.TokenIterator;
import ytx.org.apache.http.annotation.Immutable;
import ytx.org.apache.http.message.BasicTokenIterator;
import ytx.org.apache.http.protocol.HttpContext;

@Immutable
public class DefaultConnectionReuseStrategy
implements ConnectionReuseStrategy {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean keepAlive(HttpResponse response, HttpContext context) {
        HeaderIterator hit;
        if (response == null) {
            throw new IllegalArgumentException("HTTP response may not be null.");
        }
        if (context == null) {
            throw new IllegalArgumentException("HTTP context may not be null.");
        }
        ProtocolVersion ver = response.getStatusLine().getProtocolVersion();
        Header teh = response.getFirstHeader("Transfer-Encoding");
        if (teh != null) {
            if (!"chunked".equalsIgnoreCase(teh.getValue())) {
                return false;
            }
        } else if (this.canResponseHaveBody(response)) {
            Header[] clhs = response.getHeaders("Content-Length");
            if (clhs.length != 1) return false;
            Header clh = clhs[0];
            try {
                int contentLen = Integer.parseInt(clh.getValue());
                if (contentLen < 0) {
                    return false;
                }
            }
            catch (NumberFormatException ex) {
                return false;
            }
        }
        if (!(hit = response.headerIterator("Connection")).hasNext()) {
            hit = response.headerIterator("Proxy-Connection");
        }
        if (hit.hasNext()) {
            try {
                TokenIterator ti = this.createTokenIterator(hit);
                boolean keepalive = false;
                while (true) {
                    if (!ti.hasNext()) {
                        if (keepalive) {
                            return true;
                        }
                        break;
                    }
                    String token = ti.nextToken();
                    if ("Close".equalsIgnoreCase(token)) {
                        return false;
                    }
                    if (!"Keep-Alive".equalsIgnoreCase(token)) continue;
                    keepalive = true;
                }
            }
            catch (ParseException px) {
                return false;
            }
        }
        if (!ver.lessEquals(HttpVersion.HTTP_1_0)) return true;
        return false;
    }

    protected TokenIterator createTokenIterator(HeaderIterator hit) {
        return new BasicTokenIterator(hit);
    }

    private boolean canResponseHaveBody(HttpResponse response) {
        int status = response.getStatusLine().getStatusCode();
        return status >= 200 && status != 204 && status != 304 && status != 205;
    }
}

