package com.xxfc.platform.user.behavior.mapper;

import com.xxfc.platform.user.behavior.dto.BehaviorTypeDTO;
import com.xxfc.platform.user.behavior.entity.BehaviorType;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Result;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.Select;
import tk.mybatis.mapper.additional.idlist.IdListMapper;
import tk.mybatis.mapper.common.Mapper;

import java.util.List;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/8/13 14:13
 */
public interface BehaviorTypeMapper extends Mapper<BehaviorType>, IdListMapper<BehaviorType,Integer> {

    @Select("<script>select `name`,`code` from  behavior_type where `id` in <foreach collection='typeIds' open='(' item='typeId' separator=',' close=')'> #{typeId}</foreach></script>")
    @Results(value = {
            @Result(column = "name",property = "name"),
            @Result(column ="code",property = "code")
    })
    List<BehaviorTypeDTO> selectAllByIdList(@Param("typeIds") List<Integer> typeIds);
}
