package com.xxfc.platform.activity.rest.admin;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.xxfc.platform.activity.biz.ActivityLuckyDrawBiz;
import com.xxfc.platform.activity.dto.ActivityLuckDrawFindDTO;
import com.xxfc.platform.activity.entity.ActivityLuckyDraw;
import com.github.wxiaoqi.security.common.exception.BaseException;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/12/3 16:51
 */

@RestController
@RequestMapping("admin/activityLuckyDraw")
@RequiredArgsConstructor(onConstructor = @__(@Autowired))
public class ActivityLuckyDrawAdminController {
    private final ActivityLuckyDrawBiz activityLuckyDrawBiz;

    /**
     * 分页查询报名列表
     *
     * @param activityLuckDrawFindDTO
     * @return
     */
    @PostMapping("/page")
    public ObjectRestResponse<PageDataVO<ActivityLuckyDraw>> listActivtyLuckyDrawWithPage(@RequestBody ActivityLuckDrawFindDTO activityLuckDrawFindDTO) {
        PageDataVO<ActivityLuckyDraw> activityLuckyDrawPageDataVO = activityLuckyDrawBiz.listLuckDrawWithPage(activityLuckDrawFindDTO);
        return ObjectRestResponse.succ(activityLuckyDrawPageDataVO);
    }

    @PostMapping("/export")
    public void  exportActivityLuckyDrawData(@RequestBody ActivityLuckDrawFindDTO activityLuckDrawFindDTO, HttpServletResponse response){
        try {
            String name = DateTimeFormatter.ofPattern("YYYYMMddHHmmss").format(LocalDateTime.now());
            response.setContentType("application/vnd.ms-excel;charset=utf-8");
            String filename = String.format("%s-activity-luckdraw.xlsx",name);
            response.setHeader("Content-Disposition","attachment;filename="+ new String(filename.getBytes(), "iso8859-1"));
            ServletOutputStream outputStream = response.getOutputStream();
            activityLuckyDrawBiz.exportActivityLuckDrawData(activityLuckDrawFindDTO,outputStream);
            response.setCharacterEncoding("UTF-8");
        }catch (Exception ex){
            throw  new BaseException("导出数据失败");
        }

    }
}