package com.xxfc.platform.vehicle.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;
import java.util.Date;

/**
 * 分公司停靠车辆统计
 */
@Table(name = "branch_company_vehicle_count")
@Data
public class BranchCompanyVehicleCount {
    @Id
    private Long id;

    /**
     * 公司名称
     */
    @Column(name = "company_id")
    private String companyId;

    /**
     * 当前停靠车辆数量
     */
    @Column(name = "vehicle_num")
    private Integer vehicleNum;

    /**
     * 统计日期
     */
    @Column(name = "count_date")
    @DateTimeFormat(pattern="yyyy-MM-dd")
    @JsonFormat(
            pattern = "yyyy-MM-dd"
    )
    private Date countDate;

    /**
     * 统计年
     */
    @Column(name = "count_year")
    private Integer countYear;

    /**
     * 统计月
     */
    @Column(name = "count_month")
    private Integer countMonth;
    /**
     * 统计周
     */
    @Column(name = "count_week")
    private Integer countWeek;

}