package com.xxfc.platform.order.biz;

import cn.hutool.core.date.DateUtil;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.xxfc.platform.order.contant.enumerate.ReceivedStatisticsEnum;
import com.xxfc.platform.order.pojo.dto.CompanyPerformanceFindDTO;
import com.xxfc.platform.order.bo.CompanyPerformanceBo;
import com.xxfc.platform.vehicle.feign.VehicleFeign;
import lombok.RequiredArgsConstructor;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.time.LocalDate;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/11/23 14:48
 */
@Transactional(rollbackFor = Exception.class)
@Service
@RequiredArgsConstructor(onConstructor = @__(@Autowired))
public class CompanyPerformanceBiz {

     private final OrderReceivedStatisticsBiz orderReceivedStatisticsBiz;
     private final VehicleFeign vehicleFeign;

    public PageDataVO<CompanyPerformanceBo> selectCompanyPerformancePage(CompanyPerformanceFindDTO companyPerformanceFindDTO) {

        Map<Integer, String> companyMap = vehicleFeign.findCompanyMap();
        PageDataVO<CompanyPerformanceBo> pageDataVO = new PageDataVO<>();
        //日统计
        if (companyPerformanceFindDTO.getStatisticalWay() == ReceivedStatisticsEnum.DAY.getWayCode()) {
            pageDataVO = orderReceivedStatisticsBiz.selectCompanyPerformanceWithDayPage(companyPerformanceFindDTO);
        }

        //按周
        if (companyPerformanceFindDTO.getStatisticalWay() == ReceivedStatisticsEnum.WEEK.getWayCode()) {
            pageDataVO = orderReceivedStatisticsBiz.selectCompanyPerformanceWithWeekPage(companyPerformanceFindDTO);
        }
        //按月
        if (companyPerformanceFindDTO.getStatisticalWay() == ReceivedStatisticsEnum.MONTH.getWayCode()) {
            pageDataVO = orderReceivedStatisticsBiz.selectCompanyPerformanceWithMonthPage(companyPerformanceFindDTO);

        }
        List<CompanyPerformanceBo> data = pageDataVO.getData();
        if (CollectionUtils.isEmpty(data)) {
            return pageDataVO;
        }
        for (CompanyPerformanceBo companyPerformanceBo : data) {
            String companyName = companyMap == null ? "" : companyMap.get(companyPerformanceBo.getCompanyId());
            companyPerformanceBo.setCompanyName(companyName);
            if (companyPerformanceFindDTO.getStatisticalWay() == ReceivedStatisticsEnum.WEEK.getWayCode()) {
                Calendar cal = Calendar.getInstance();
                cal.setFirstDayOfWeek(Calendar.MONDAY);
                cal.set(Calendar.YEAR, companyPerformanceBo.getYear());
                cal.set(Calendar.WEEK_OF_YEAR, Integer.valueOf(companyPerformanceBo.getWeekOfYear().replace("" + companyPerformanceBo.getYear(), "")));
                cal.set(Calendar.DAY_OF_WEEK, cal.getFirstDayOfWeek());
                Date startDate = cal.getTime();
                cal.add(Calendar.DAY_OF_WEEK, 6);
                Date endDate = cal.getTime();
                companyPerformanceBo.setStartDate(DateUtil.beginOfDay(startDate));
                companyPerformanceBo.setEndDate(DateUtil.beginOfDay(endDate));
            }
        }
        return pageDataVO;
    }
}
