package com.xxfc.platform.order.entity;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;


/**
 * 会员订单统计
 *
 * @author libin
 * @email 18178966185@163.com
 * @date 2019-11-08 18:03:42
 */
@Data
@Table(name = "order_member_received_statistics")
public class OrderMemberReceivedStatistics extends OrderReceivedStatisticsBase implements Serializable {
    private static final long serialVersionUID = 1L;


    /**
     * 普通会员订单总额
     */
    @Column(name = "toal_common_ammount")
    @ApiModelProperty(value = "普通会员订单总额")
    private BigDecimal toalCommonAmmount;

    /**
     * 普通会员订单总量
     */
    @Column(name = "total_common_quantity")
    @ApiModelProperty(value = "普通会员订单总量")
    private Integer totalCommonQuantity;

    /**
     * 黄金会员订单总额
     */
    @Column(name = "total_gold_amount")
    @ApiModelProperty(value = "黄金会员订单总额")
    private BigDecimal totalGoldAmount;

    /**
     * 黄金会员订单总量
     */
    @Column(name = "total_gold_quantity")
    @ApiModelProperty(value = "黄金会员订单总量")
    private Integer totalGoldQuantity;

    /**
     * 钻石会员订单总额
     */
    @Column(name = "total_diamond_ammount")
    @ApiModelProperty(value = "钻石会员订单总额")
    private BigDecimal totalDiamondAmmount;

    /**
     * 钻石会员订单总量
     */
    @Column(name = "total_diamond_quantity")
    @ApiModelProperty(value = "钻石会员订单总量")
    private Integer totalDiamondQuantity;

}
