package com.github.wxiaoqi.security.admin.rest.admin;

import com.github.wxiaoqi.security.admin.biz.StaffStatisticsBiz;
import com.github.wxiaoqi.security.admin.dto.StaffStatisticsFindDTO;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Map;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/11/26 16:59
 */
@RestController
@RequestMapping("/staff_statistics")
@RequiredArgsConstructor(onConstructor = @__(@Autowired))
public class StaffStatisticsAdminController {

       private final StaffStatisticsBiz staffStatisticsBiz;

       @PostMapping("/page")
       public ObjectRestResponse<Map<String,Object>> lisetStaffStatisticsWithPage(@RequestBody StaffStatisticsFindDTO staffStatisticsFindDTO){
           Map<String,Object> result =  staffStatisticsBiz.listStaffStatisticsWithPage(staffStatisticsFindDTO);
           return ObjectRestResponse.succ(result);
       }
}
