package com.github.wxiaoqi.security.admin.vo;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/9/23 18:38
 */
@Builder(toBuilder = true)
@Data
@NoArgsConstructor
@AllArgsConstructor
public class AppUserPositionTempVo {

    private Integer id;

    @ApiModelProperty(value = "手机号码")
    private String phone;

    @ApiModelProperty(value = "姓名")
    private String name;

    @ApiModelProperty(value = "职位名")
    private String positionName;

    private Integer positionId;

    @ApiModelProperty(value = "数据状态 1：已核销 2：未核销")
    private Integer status;

    @ApiModelProperty(value = "创建时间", hidden = true )
    private Long crtTime;

    @ApiModelProperty(value = "员工职位id")
    private Integer jobId;

    @ApiModelProperty(value = "员工职位名称")
    private String jobName;


    @ApiModelProperty(value = "分公司id")
    private Integer companyId;


    @ApiModelProperty(value = "分公司名称")
    private String companyName;
}
