package com.xxfc.platform.universal.service;


import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.util.process.SystemConfig;
import com.xxfc.platform.universal.constant.RedisKey;
import com.xxfc.platform.universal.utils.ImgBase64Util;
import org.apache.commons.io.FileUtils;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

import java.io.File;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

@Service
public class    UploadService {

    public static final DateTimeFormatter DEFAULT_DATE_TIME_FORMATTER = DateTimeFormat.forPattern("yyyy-MM-dd");
    @Value("${universal.baseUploadPath}")
    private String baseUploadPath ;
    @Value("${universal.videoUploadPath}")
    private String videoUploadPath ;

    @Value("${universal.url}")
    private String xx_url ;
    @Autowired
    private RedisTemplate redisTemplate;

    /**
     * 写入上传文件，返回相对路径
     * @param file
     * @return
     */
    public String uploadFile(MultipartFile file,String prefix) throws Exception{
        //创建本日存放目录
        DateTime now = DateTime.now();
        String dirPathToday = "/"+prefix+ "/" + now.toString(DEFAULT_DATE_TIME_FORMATTER);
        String redisNoKey = RedisKey.UPLOAD_FILE_NO_PREFIX + now.toString(DEFAULT_DATE_TIME_FORMATTER);
        Long no = redisTemplate.opsForValue().increment(redisNoKey);
        if(no.equals(1l)){
            redisTemplate.expire(redisNoKey,1, TimeUnit.DAYS);
        }
        String fileName = file.getOriginalFilename();
        String realFileRelPath = dirPathToday + "/" + no + fileName.substring(fileName.lastIndexOf("."));
        //文件存放路径
        String filePath = baseUploadPath + realFileRelPath;
        //将文件写入指定位置
        FileUtils.copyInputStreamToFile(file.getInputStream(), new File(filePath));
        realFileRelPath=xx_url+SystemConfig.XXMP_URL+realFileRelPath;
        return realFileRelPath;
    }

    /**
     * 写入上传文件，返回相对路径
     * @param imgFile
     * @return
     */
    public String uploadImg(String imgFile,String prefix) throws Exception{
        //创建本日存放目录
        DateTime now = DateTime.now();
        String dirPathToday = "/"+prefix+ "/" + now.toString(DEFAULT_DATE_TIME_FORMATTER);
        String redisNoKey = RedisKey.UPLOAD_FILE_NO_PREFIX + now.toString(DEFAULT_DATE_TIME_FORMATTER);
        Long no = redisTemplate.opsForValue().increment(redisNoKey);
        if(no.equals(1l)){
            redisTemplate.expire(redisNoKey,1, TimeUnit.DAYS);
        }

        String realFileRelPath = dirPathToday;
        //文件存放路径
        String filePath = baseUploadPath + realFileRelPath;
        File file=new File(filePath);
        if(!file.exists()){
            file.mkdirs();

        }
         String str="/" + no + ".jpg";
        realFileRelPath = realFileRelPath+str;
        filePath=filePath +str;
        //将文件写入指定位置
        ImgBase64Util.generateImage(imgFile,filePath);
        realFileRelPath=xx_url+SystemConfig.XXMP_URL+realFileRelPath;
        return realFileRelPath;
    }


    /**
     * @Method: makeFileName
     * @Description: 生成上传文件的文件名，文件名以：uuid+"_"+文件的原始名称
     * @param filename 文件的原始名称
     * @return uuid+"_"+文件的原始名称
     */
    private String makeFileName(String filename){  //2.jpg
        //为防止文件覆盖的现象发生，要为上传文件产生一个唯一的文件名
        return UUID.randomUUID().toString() + "_" + filename;
    }

    /**
     * 为防止一个目录下面出现太多文件，要使用hash算法打散存储
     * @Method: makePath
     * @Description:
     *
     * @param filename 文件名，要根据文件名生成存储目录
     * @param savePath 文件存储路径
     * @return 新的存储目录
     */
    private String makePath(String filename,String savePath){
        //得到文件名的hashCode的值，得到的就是filename这个字符串对象在内存中的地址
        int hashcode = filename.hashCode();
        int dir1 = hashcode&0xf;  //0--15
        int dir2 = (hashcode&0xf0)>>4;  //0-15
        //构造新的保存目录
        String dir = savePath + "\\" + dir1 + "\\" + dir2;  //upload\2\3  upload\3\5
        //File既可以代表文件也可以代表目录
        File file = new File(dir);
        //如果目录不存在
        if(!file.exists()){
            //创建目录
            file.mkdirs();
        }
        return dir;
    }

    /**
     * 下载图片
     * @param realFileRelPath
     * @return
     * @throws Exception
     */
    public ResponseEntity<byte[]> downloadFile(String realFileRelPath) throws Exception{
        String filePath = baseUploadPath + realFileRelPath;
        File file = new File(filePath);//新建一个文件
        HttpHeaders headers = new HttpHeaders();//http头信息
        String downloadFileName = new String(file.getName());//设置编码
        headers.setContentDispositionFormData("attachment", downloadFileName);
        headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
        return new ResponseEntity<byte[]>(FileUtils.readFileToByteArray(file),headers, HttpStatus.CREATED);
    }

    /**
     * 写入上传文件，返回相对路径
     * @param file
     * @return
     */
    public String uploadVideo(MultipartFile file,String prefix) throws Exception{
        //创建本日存放目录
        DateTime now = DateTime.now();
        String dirPathToday = "/"+prefix+ "/" + now.toString(DEFAULT_DATE_TIME_FORMATTER);
        String redisNoKey = RedisKey.UPLOAD_FILE_NO_PREFIX + now.toString(DEFAULT_DATE_TIME_FORMATTER);
        Long no = redisTemplate.opsForValue().increment(redisNoKey);
        if(no.equals(1l)){
            redisTemplate.expire(redisNoKey,1, TimeUnit.DAYS);
        }
        String fileName = file.getOriginalFilename();
        String realFileRelPath = dirPathToday + "/" + no + fileName.substring(fileName.lastIndexOf("."));
        //文件存放路径
        String filePath = videoUploadPath + realFileRelPath;
        //将文件写入指定位置
        FileUtils.copyInputStreamToFile(file.getInputStream(), new File(filePath));
        realFileRelPath=xx_url+SystemConfig.VIDEO_URL+realFileRelPath;
        return realFileRelPath;
    }


}
