package com.xxfc.platform.vehicle.biz;

import com.alibaba.fastjson.JSON;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.xxfc.platform.universal.entity.Dictionary;
import com.xxfc.platform.universal.feign.ThirdFeign;
import com.xxfc.platform.vehicle.entity.VehicleProfileDisplay;
import com.xxfc.platform.vehicle.mapper.VehicleProfileDisplayMapper;
import com.xxfc.platform.vehicle.pojo.bo.LargeScreenDisplayCCTConstantDataBo;
import com.xxfc.platform.vehicle.pojo.vo.LargeScreenDisplayBaseDataVo;
import com.xxfc.platform.vehicle.pojo.vo.VehicleProfileDisplayVo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

import java.util.List;
import java.util.concurrent.CountDownLatch;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/12/24 17:06
 */
@Slf4j
@Transactional(rollbackFor = Exception.class)
@Service
@RequiredArgsConstructor(onConstructor = @__(@Autowired))
public class VehicleProfileDisplayBiz extends BaseBiz<VehicleProfileDisplayMapper, VehicleProfileDisplay> {
    /**
     * 字典查询type
     */
    @Value("large.screen.type:LARGE_SCREEN_DISPLAY")
    private String largeScreenType;
    /**
     * 字典查询code
     */
    @Value("large.screen.cct.code:LARGE_SCREEN_DISPLAY_CCT_CONSTANT")
    private String largeScreenCode;

    private final ThirdFeign thirdFeign;
    private final ThreadPoolTaskExecutor executor;

    public LargeScreenDisplayBaseDataVo findVehicleProfileDisplayData() {
        LargeScreenDisplayBaseDataVo largeScreenDisplayBaseDataVo = new LargeScreenDisplayBaseDataVo();
        VehicleProfileDisplayVo vehicleProfileDisplayVo = new VehicleProfileDisplayVo();
        //1.查询全部固定数据
        List<VehicleProfileDisplay> vehicleProfileDisplays = mapper.selectAll();
        CountDownLatch latch = new CountDownLatch(1);
        executor.execute(()->{
             try {
                 Dictionary dictionary = thirdFeign.findDictionaryByTypeAndCode(largeScreenType, largeScreenType);
                 if (dictionary != null && StringUtils.hasText(dictionary.getDetail())) {
                     LargeScreenDisplayCCTConstantDataBo largeScreenDisplayConstantDataBo = JSON.parseObject(dictionary.getDetail(), LargeScreenDisplayCCTConstantDataBo.class);
                     largeScreenDisplayBaseDataVo.setLargeScreenDisplayCCTConstantDataBo(largeScreenDisplayConstantDataBo);
                 }
             }catch (Exception ex){
                 log.error("字典数据查询失败【{}】",ex);
             }finally {
                 latch.countDown();
             }
        });
        if (CollectionUtils.isEmpty(vehicleProfileDisplays)) {
            try {
                latch.await();
            } catch (InterruptedException e) {
                log.error("查询失败【{}】",e);
            }
            return largeScreenDisplayBaseDataVo;
        }
        long travelNum = 0;
        long toTravelNum = 0;
        long maintenanceNum = 0;
        long inMaintenanceNum = 0;
        for (VehicleProfileDisplay vehicleProfileDisplay : vehicleProfileDisplays) {
            travelNum = +vehicleProfileDisplay.getTravelNum();
            toTravelNum = +vehicleProfileDisplay.getToTravelNum();
            maintenanceNum = +vehicleProfileDisplay.getMaintenanceNum();
            inMaintenanceNum = +vehicleProfileDisplay.getInMaintenanceNum();
        }

        vehicleProfileDisplayVo.setTravelNum(travelNum);
        vehicleProfileDisplayVo.setToTravelNum(toTravelNum);
        vehicleProfileDisplayVo.setMaintenanceNum(maintenanceNum);
        vehicleProfileDisplayVo.setInMaintenanceNum(inMaintenanceNum);
        largeScreenDisplayBaseDataVo.setVehicleProfileDisplayVo(vehicleProfileDisplayVo);
        try {
            latch.await();
        } catch (InterruptedException e) {
            log.error("查询失败【{}】",e);
        }
        return largeScreenDisplayBaseDataVo;
    }
}
