package com.xxfc.platform.vehicle.pojo.vo;

import com.xxfc.platform.vehicle.entity.VehicleProfileDisplay;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.apache.commons.collections4.CollectionUtils;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/12/25 9:50
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class VehicleProfileDisplayVo implements Serializable {
    private static final long serialVersionUID = 1L;
    /**
     * 出行中
     */
    private long travelNum;

    /**
     * 待出行
     */
    private long toTravelNum;

    /**
     * 保养中
     */
    private long maintenanceNum;
    /**
     * 维修中
     */
    private long inMaintenanceNum;
    /**
     * 每个省份车辆概况数据
     */
    private List<VehicleProfileDisplay> vehicleProfileDisplays;

    public List<VehicleProfileDisplay> getVehicleProfileDisplays() {
        return CollectionUtils.isEmpty(vehicleProfileDisplays) ? Collections.EMPTY_LIST : vehicleProfileDisplays;
    }
}
