package com.xxfc.platform.vehicle.entity;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.*;

/**
 * @author libin
 * @version 1.0
 * @description 车型概况
 * @data 2019/12/24 16:32
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Entity
@Table(name = "vehicle_profile_display")
public class VehicleProfileDisplay {
    @Id
    @GeneratedValue(generator = "JDBC")
    private Integer id;
    /**
     * 省份code
     */
    @Column(name = "province_code")
    private Integer provinceCode;
    /**
     * 省份名
     */
    @Column(name = "province_name")
    private String provinceName;
    /**
     * 出行中
     */
    @Column(name = "travel_num")
    private Integer travelNum;

    /**
     * 待出行
     */
    @Column(name = "to_travel_num")
    private Integer toTravelNum;

    /**
     * 保养中
     */
    @Column(name = "maintenance_num")
    private Integer maintenanceNum;
    /**
     * 维修中
     */
    @Column(name = "in_maintenance_num")
    private Integer inMaintenanceNum;

}
