package com.xxfc.platform.order.rest;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.xxfc.platform.order.biz.OrderProfileDisplayBiz;
import com.xxfc.platform.order.pojo.vo.LargeScreenDisplayDataVo;
import com.xxfc.platform.order.pojo.vo.UserProfileDisplayVo;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.Date;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/12/24 16:29
 */
@RestController
@RequestMapping("/large_screen")
@RequiredArgsConstructor(onConstructor = @__(@Autowired))
public class LargeScreenDisplayController {


    private final OrderProfileDisplayBiz orderProfileDisplayBiz;


    /**
     * 基础数据 与 订单概况
     *
     * @param startDate
     * @param endDate
     * @return
     */
    @GetMapping("/order_profile_display")
    public ObjectRestResponse<LargeScreenDisplayDataVo> findLargeScreenDisplayData(@RequestParam(value = "startDate") Date startDate,
                                                                                   @RequestParam(value = "endDate") Date endDate) {
        LargeScreenDisplayDataVo largeScreenDisplayDataVo = orderProfileDisplayBiz.findLargeScreenDisplayDataByDate(startDate, endDate);
        return ObjectRestResponse.succ(largeScreenDisplayDataVo);
    }
}
