package com.github.wxiaoqi.security.admin.rest;

import com.github.wxiaoqi.security.admin.biz.BaseUserMemberBiz;
import com.github.wxiaoqi.security.admin.dto.BaseUserMemberVO;
import com.github.wxiaoqi.security.admin.dto.UserMemberDTO;
import com.github.wxiaoqi.security.admin.entity.AppUserManage;
import com.github.wxiaoqi.security.admin.entity.BaseUserMember;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import org.springframework.web.bind.annotation.*;

import java.lang.reflect.InvocationTargetException;

/**
 * 用户会员
 * @author Administrator
 */
@RestController
@RequestMapping("baseUserMember")
public class BaseUserMemberController extends BaseController<BaseUserMemberBiz, BaseUserMember> {

    /**
     * 获取用户会员
     * @param userId
     * @return
     */
    @RequestMapping("/findOne/{userId}")
    public ObjectRestResponse<BaseUserMemberVO> findOneByUserId(@PathVariable Integer userId){

        return  ObjectRestResponse.succ(baseBiz.findOneByUserId(userId));
    }



//    /**
//     * 设置用户会员
//     * @param userMemberDTO
//     * @return
//     */
//    @PutMapping("/setUserMember")
//    public ObjectRestResponse UpdateUserMember(@RequestBody BaseUserMemberVO baseUserMemberVO)
//            throws Exception {
//        baseBiz.UpdateUserMember(baseUserMemberVO);
//        return ObjectRestResponse.succ();
//    }


    /**
     * 设置用户会员
     * @param userMemberDTO
     * @return
     */
    @PutMapping("/setUserMember")
    public ObjectRestResponse UpdateUserMember(@RequestBody UserMemberDTO userMemberDTO)
            throws Exception {
        if (userMemberDTO==null||userMemberDTO.getRentFreeDays()<0||userMemberDTO.getTotalNumber()<0) {
            return ObjectRestResponse.createDefaultFail();
        }


        baseBiz.UpdateUserMember(userMemberDTO);
        return ObjectRestResponse.succ();
    }
}
