package com.xxfc.platform.order.rest;

import com.github.wxiaoqi.security.admin.feign.UserFeign;
import com.github.wxiaoqi.security.admin.feign.rest.UserRestInterface;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreClientToken;
import com.github.wxiaoqi.security.common.constant.CommonConstants;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.github.wxiaoqi.security.common.util.Query;
import com.github.wxiaoqi.security.common.vo.PageParam;
import com.xxfc.platform.order.biz.BaseOrderBiz;
import com.xxfc.platform.order.biz.OrderAccountBiz;
import com.xxfc.platform.order.biz.OrderItemBiz;
import com.xxfc.platform.order.biz.OrderRefundBiz;
import com.xxfc.platform.order.biz.inner.OrderCalculateBiz;
import com.xxfc.platform.order.biz.inner.OrderCancelBiz;
import com.xxfc.platform.order.contant.enumerate.ItemTypeEnum;
import com.xxfc.platform.order.contant.enumerate.OrderTypeEnum;
import com.xxfc.platform.order.entity.OrderItem;
import com.xxfc.platform.order.entity.OrderRefund;
import com.xxfc.platform.order.entity.OrderRentVehicleDetail;
import com.xxfc.platform.order.pojo.calculate.InProgressVO;
import com.xxfc.platform.order.pojo.order.OrderPageVO;
import com.xxfc.platform.universal.constant.DictionaryKey;
import lombok.Data;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.math.BigDecimal;
import java.math.RoundingMode;

import static com.github.wxiaoqi.security.common.constant.CommonConstants.SYS_FALSE;
import static com.github.wxiaoqi.security.common.constant.CommonConstants.SYS_TRUE;
import static com.xxfc.platform.universal.constant.DictionaryKey.*;

@Controller
@RequestMapping("orderRefund")
public class OrderRefundController extends BaseController<OrderRefundBiz,OrderRefund> implements UserRestInterface {

    @Autowired
    BaseOrderBiz baseOrderBiz;

    @Autowired
    OrderAccountBiz orderAccountBiz;

    @Autowired
    OrderItemBiz orderItemBiz;

    @Autowired
    OrderCalculateBiz orderCalculateBiz;

    @Autowired
    UserFeign userFeign;

    @Override
    public UserFeign getUserFeign() {
        return userFeign;
    }

    @RequestMapping(value = "/price/calculate/{no}", method = RequestMethod.GET)
    @ResponseBody
    @IgnoreClientToken
    public ObjectRestResponse<BigDecimal> getPriceCalculate(@PathVariable(value = "no") String no) {
        checkAppUser();
        //根据no 查订单
        OrderPageVO orderPageVO = baseOrderBiz.pageByParm(new Query(new PageParam(){{
            setLimit(1);
            setPage(1);
        }}){{put("no", no); }}.getSuper()).get(0);

        OrderTypeEnum orderTypeEnum = OrderTypeEnum.get(orderPageVO.getType());

        BigDecimal orderRefundAmount = BigDecimal.ZERO;
        StringBuilder refundDescBuilder = new StringBuilder("");

        switch (orderTypeEnum) {
            case RENT_VEHICLE:
                DateTime nowTime = DateTime.parse(DateTime.now().toString(CommonConstants.YMR_SLASH_FORMATTER_JODA), CommonConstants.YMR_SLASH_FORMATTER_JODA);
                DateTime startTime = DateTime.parse(new DateTime(orderPageVO.getOrderRentVehicleDetail().getStartTime()).toString(CommonConstants.YMR_SLASH_FORMATTER_JODA), CommonConstants.YMR_SLASH_FORMATTER_JODA);

                InProgressVO inProgressVO = orderCalculateBiz.inProgressCalculate(orderPageVO, baseOrderBiz.getDaysBetweenDateTime(startTime, nowTime));
//                orderRefundAmount = orderAccountBiz.calculateDeduction(orderPageVO.getGoodsAmount().subtract(orderPageVO.getCouponAmount())
//                        , orderPageVO.getOrderRentVehicleDetail().getStartTime() - System.currentTimeMillis()
//                        , DictionaryKey.APP_ORDER+ "_"+ RENT_REFUND
//                        , refundDescBuilder);
//                OrderRentVehicleDetail orvd = orderPageVO.getOrderRentVehicleDetail();
//                Long timeLag = orvd.getStartTime() - System.currentTimeMillis();
//                //原退还押金
//                BigDecimal originalDeductAmount = BigDecimal.ZERO;
//                BigDecimal originalRefundAmount = BigDecimal.ZERO.add(orvd.getDeposit());
//                //判断是否使用免费天数，并且进行扣款
//                if(null != orvd.getFreeDays() && orvd.getFreeDays() > 0) {
//                    refundDescBuilder = new StringBuilder("");
//                    OrderItem orderItem = orderItemBiz.selectOne(new OrderItem(){{
//                        setType(ItemTypeEnum.VEHICLE_MODEL.getCode());
//                        setOrderId(orderPageVO.getId());
//                    }});
//                    originalDeductAmount = orderItem.getUnitPrice().multiply(new BigDecimal(orvd.getFreeDays()+ ""));
//                }
//                BigDecimal residueAmount = orderRefundBiz.calculateDeduction(originalDeductAmount, timeLag, APP_ORDER+ "_"+ RENT_REFUND, refundDescBuilder);
                //扣款 = 违约金 + 消费金额
                BigDecimal residueAmount = BigDecimal.ZERO;
                        //inProgressVO.get
                residueAmount = residueAmount.setScale(2, RoundingMode.HALF_UP);

                //押金剩余款 ：押金 - (原扣除款 - 剩余款)
                //退款金额 ：订单剩余款 + 押金剩余款
                //orderRefundAmount = orderRefundAmount.add(originalRefundAmount.subtract(originalDeductAmount.subtract(residueAmount)));

                break;
            case TOUR:
                //判断是省内还是省外
//                String key = TOUR_IN_REFUND;
//                if(SYS_TRUE.equals(orderPageVO.getOrderTourDetail().getIsOutside())) {
//                    key = TOUR_REFUND;
//                }
//                orderRefundAmount = orderRefundBiz.calculateDeduction(orderPageVO.getGoodsAmount().subtract(orderPageVO.getCouponAmount())
//                        , orderPageVO.getOrderTourDetail().getStartTime() - System.currentTimeMillis()
//                        , DictionaryKey.APP_ORDER+ "_"+ key
//                        , refundDescBuilder);
//                break;
            default:
                break;
        }

        OrderRefundPriceVO orpv = new OrderRefundPriceVO();
        orpv.setRealAmount(orderPageVO.getRealAmount());
        orpv.setRefundAmount(orderRefundAmount);
        orpv.setRefundDesc(refundDescBuilder.toString());
        return ObjectRestResponse.succ(orpv);
    }

    @Data
    public class OrderRefundPriceVO {
        BigDecimal refundAmount;
        BigDecimal realAmount;
        BigDecimal cutAmount;
        String refundDesc;

        public void setRefundAmount(BigDecimal refundAmount) {
            this.refundAmount = refundAmount;
            this.cutAmount = realAmount.subtract(refundAmount);
        }
    }
}