package com.xxfc.platform.order.pojo.price;

import cn.hutool.json.JSONUtil;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

@Data
public class OrderPriceVO {
    @ApiModelProperty(value = "订单总金额")
    public BigDecimal orderAmount = BigDecimal.ZERO;
    @ApiModelProperty(value = "商品价格")
    public BigDecimal goodsAmount = BigDecimal.ZERO;
    @ApiModelProperty(value = "实际价格")
    public BigDecimal realAmount = BigDecimal.ZERO;
    @ApiModelProperty(value = "优惠券扣除的费用")
    public BigDecimal couponAmount = BigDecimal.ZERO;

    @ApiModelProperty(value = "参数json")
    public String paramJson = "";

    public void initParamJson() {
        paramJson = JSONUtil.toJsonStr(this);
    }
}
