package com.github.wxiaoqi.security.admin.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/7/12 8:42
 */
@Data
public class WalletDTO {

    @ApiModelProperty(value = "id")
    private Long id;

    /**
     *  用户ID
     */
    @ApiModelProperty("用户ID")
    private Integer userId;

    /**
     *  余额(分)
     */
    @ApiModelProperty(value = "余额(元)")
    private BigDecimal balance;

    /**
     *  已提现金额
     */
    @ApiModelProperty(value = "已提现金额")
    private BigDecimal withdrawals;

    /**
     *  进账总额（元）
     */
    @ApiModelProperty(value = "进账总额(元)")
    private BigDecimal totalAmount;

    /**
     *  进账总额(分)
     */
    @ApiModelProperty(value = "进账总额(元)")
    private BigDecimal todayAmount;

    /**
     *  未入账金额
     */
    @ApiModelProperty(value = "未入账金额")
    private BigDecimal unbooked;

    /**
     *  是否冻结：0-正常，1-冻结
     */
    @ApiModelProperty(value = "是否冻结：0-正常，1-冻结")
    private Integer isFrozen;

    /**
     *  最后进账时间
     */
    @ApiModelProperty(value = "最后进账时间")
    private Long lastIntime;

}
