package com.xxfc.platform.order.pojo.order;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.xxfc.platform.order.entity.OrderItem;
import com.xxfc.platform.vehicle.feign.VehicleFeign;
import com.xxfc.platform.vehicle.pojo.dto.VehicleModelCalendarPriceDTO;
import com.xxfc.platform.vehicle.pojo.dto.order.VMCalendarPriceCostDTO;
import lombok.Data;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.List;

@Data
public class VehicleItemDTO extends OrderItem {
    public static final int topNum = 2;
    //已抵消天数
    private Integer offsetNum = 0;
    public BigDecimal calculateVehicleUnitPrice(BigDecimal vehicleAmount, BigDecimal metaVehicleAmount, Boolean isSetRealAmount) {
        if(isSetRealAmount) {
            setRealAmount(vehicleAmount);
        }

        BigDecimal unitPrice = BigDecimal.ZERO;
        BigDecimal metaUnitPrice = BigDecimal.ZERO;

        if(getCalculateNum() > 0) {
            unitPrice = vehicleAmount.divide(new BigDecimal(getCalculateNum()+ ""), 2, RoundingMode.HALF_UP);
            metaUnitPrice = metaVehicleAmount.divide(new BigDecimal(getCalculateNum()+ ""), 2, RoundingMode.HALF_UP);
        }

        setUnitPrice(unitPrice);
        setMetaUnitPrice(metaUnitPrice);

        return unitPrice;
    }

    public BigDecimal getCutAmount() {
        List<VMCalendarPriceCostDTO> vmcpds = getVehicleDetail();
        if(CollUtil.isEmpty(vmcpds)){
            return super.getCutAmount();
        }
        BigDecimal cutAmount = BigDecimal.ZERO;
//        for(int i = 0; i < getCutNum(); i++) {
        for(VMCalendarPriceCostDTO vmcpd : vmcpds) {
            cutAmount = cutAmount.add(vmcpd.getFreeAmount());
        }
        return cutAmount;
    }

    public List<VMCalendarPriceCostDTO> getVehicleDetail() {
        if(StrUtil.isBlank(getDetail())) {
            return CollUtil.newArrayList();
        }
        return JSONUtil.toList(JSONUtil.parseArray(getDetail()), VMCalendarPriceCostDTO.class);
    }

    public BigDecimal getBuyAmount() {
        List<VMCalendarPriceCostDTO> vmcpds = getVehicleDetail();
        if(CollUtil.isEmpty(vmcpds)){
            return super.getBuyAmount();
        }
        BigDecimal buyAmount = BigDecimal.ZERO;
        for(int i = 0; i < getBuyNum(); i++) {
        //for(VMCalendarPriceCostDTO vmcpd : vmcpds) {
            buyAmount = buyAmount.add(vmcpds.get(i).getPrice());
        }
        return buyAmount;
    }

    public BigDecimal getTopAmount(Integer useDays) {
        List<VMCalendarPriceCostDTO> vmcpds = getVehicleDetail();
        if(CollUtil.isEmpty(vmcpds)){
            return getUnitPrice().multiply(new BigDecimal(topNum+ ""));
        }
        BigDecimal topAmount = BigDecimal.ZERO;
        for(int i = useDays; i < getTotalNum(); i++) {
            if((i - useDays) >= topNum) {
                break;
            }else {
                topAmount = topAmount.add(vmcpds.get(i).getPrice());
            }
        }

        //未用天数 小于 topNum
        if(getTotalNum() - useDays < topNum) {
            Integer residue = getTotalNum() - useDays;
            topAmount = topAmount.add(vmcpds.get(vmcpds.size() - 1).getPrice().multiply(new BigDecimal((topNum - residue) + "")));
        }
        return topAmount;
    }

    public BigDecimal getUsedAmount(Integer useDays) {
        return getUnitPrice().multiply(new BigDecimal(useDays+ ""));
    }

    public BigDecimal getFreeAmount(Integer freeDays) {
        List<VMCalendarPriceCostDTO> vmcpds = getVehicleDetail();
        if(CollUtil.isEmpty(vmcpds)){
            return getUnitPrice().multiply(new BigDecimal(freeDays+ ""));
        }
        BigDecimal freeAmount = BigDecimal.ZERO;
        for(int i = 0; i < getBuyNum(); i++) {
            freeAmount = freeAmount.add(vmcpds.get(i).getPrice());
        }
        return freeAmount;
    }

//    public Integer getActualNum() {
//
//    }

    public void initDetail(Integer ableFreeDays) {
        if(StrUtil.isNotBlank(getDetail())) {
            List<VehicleModelCalendarPriceDTO> metaList = JSONUtil.toList(JSONUtil.parseArray(getDetail()), VehicleModelCalendarPriceDTO.class);
            //计算消费金额
            List<VMCalendarPriceCostDTO> list = Convert.toList(VMCalendarPriceCostDTO.class, metaList);

            //循环价格列表 获得对应消耗的免费天数
                //循环已标记的已使用免费天数
            Integer cycleNum = 0;
            for(VMCalendarPriceCostDTO dto : list) {
                if(ableFreeDays > cycleNum && cycleNum+ dto.getFreeDays() > ableFreeDays) { //本次累加天数 大于 可用免费天数
                    setCutNum(ableFreeDays);

                    Integer up = (ableFreeDays - cycleNum);
                    Integer down = dto.getFreeDays();
                    //根据百分比计算消费价格
                    dto.setFreeAndConsumeAmount(dto.getPrice(), dto.getPrice().multiply(
                            new BigDecimal(up+ "").divide(new BigDecimal(down+ ""), 2, RoundingMode.HALF_UP))
                            .setScale(2, RoundingMode.HALF_UP));
                }else if(ableFreeDays > cycleNum){ //本次累加天数 小于等于 可用免费天数
                    setCutNum(getCutNum()+ dto.getFreeDays());
                    //直接设置价格
                    dto.setFreeAndConsumeAmount(dto.getPrice(), dto.getPrice());
                    this.offsetNum += 1;
                }else { //上次累加天数 大于 可用天数
                    //直接设置价格
                    dto.setFreeAndConsumeAmount(dto.getPrice(), BigDecimal.ZERO);
                }
                cycleNum += dto.getFreeDays();
            }

            setDetail(JSONUtil.parseArray(list).toString());
        }
    }
}
