package com.xxfc.platform.uccn.rest;

import cn.hutool.core.bean.BeanUtil;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreClientToken;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreUserToken;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.CommonBaseController;
import com.xxfc.platform.vehicle.entity.VehicleModel;
import com.xxfc.platform.vehicle.feign.VehicleFeign;
import com.xxfc.platform.vehicle.pojo.VModelDetailVO;
import com.xxfc.platform.vehicle.pojo.VehicleModelQueryCondition;
import com.xxfc.platform.vehicle.pojo.VehicleModelVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;

@RestController
@RequestMapping("/vehicleModel/app/unauth")
@Slf4j
@IgnoreClientToken
@Api(tags = "房车车型", value = "房车车型")
public class VehicleModelController extends CommonBaseController {

    @Autowired
    VehicleFeign vehicleFeign;

    /**
     * 车型详情
     *
     * @param name
     * @return
     */
    @ApiOperation("车型详情")
    @RequestMapping(value = "/detail/{name}", method = RequestMethod.GET)
    @IgnoreUserToken
    public ObjectRestResponse<VModelDetailVO> detail(@PathVariable("name") @ApiParam("车型名称") String name) {
        return vehicleFeign.detailByParam(BeanUtil.beanToMap(new VehicleModel(){{
            setName(name);
        }}, false, true));
    }

    /**
     * 车型列表查
     *
     * @param vmqc 条件
     * @return
     */
    @ApiOperation("车型列表")
    @PostMapping(value = "/findVehicleModelPage")
    @IgnoreUserToken
    public ObjectRestResponse<VehicleModelVo> findVehicleModelPageUnauthfind(@RequestBody VehicleModelQueryCondition vmqc) {
        return vehicleFeign.findVehicleModelPageUnauthfind(vmqc);
    }
}
