package com.xxfc.platform.uccn.rest;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.xxfc.platform.uccn.biz.SummitActivityBiz;
import com.xxfc.platform.uccn.vo.SummitActivityDetailVo;
import com.xxfc.platform.uccn.vo.SummitActivityVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author libin
 * @version 1.0
 * @description 
 * @data 2019/8/26 15:36
 */
@RestController
@RequestMapping("/summitActivity/app/unauth")
@RequiredArgsConstructor(onConstructor = @__(@Autowired))
@Api("峰会")
public class SummitActivityController{

     private final  SummitActivityBiz summitActivityBiz;

     @ApiOperation("官网首页展示")
     @GetMapping("/home")
     public ObjectRestResponse<List<SummitActivityVo>>  findSummitActivityForHomePage(@RequestParam(defaultValue = "5",required = false) Integer limit,@RequestParam(value = "location",defaultValue = "1",required = false) Integer location){

          List<SummitActivityVo> summitActivityVos = summitActivityBiz.findSummitActivityForHomePage(limit,location);
          return ObjectRestResponse.succ(summitActivityVos);
     }

     @ApiOperation("峰会活动详情")
     @GetMapping("/{id}")
     public ObjectRestResponse<SummitActivityDetailVo> findSummitActivityDetailById(@PathVariable(value = "id") Integer id){
           SummitActivityDetailVo summitActivityDetailVo = summitActivityBiz.findSummitActivityDetailById(id);
          return ObjectRestResponse.succ(summitActivityDetailVo);
     }

     @ApiOperation("热门推荐获取")
     @GetMapping("/hot")
     public ObjectRestResponse<List<SummitActivityVo>> findHotWithSummitActivity(@RequestParam(value = "num",required = false,defaultValue = "2") Integer num,@RequestParam(value = "location",defaultValue = "1",required = false) Integer location){
          List<SummitActivityVo> summitActivityVos = summitActivityBiz.getHostWithSummitActivity(num,location);
          return ObjectRestResponse.succ(summitActivityVos);
     }

}