package com.xxfc.platform.uccn.biz;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.xxfc.platform.campsite.feign.CampsiteFeign;
import com.xxfc.platform.tour.feign.TourFeign;
import com.xxfc.platform.uccn.vo.TypeEnum;
import com.xxfc.platform.vehicle.feign.VehicleFeign;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 获取随机数量的车型、旅游、营地、活动
 */
@Service
@Slf4j
public class RandomListBiz {

    @Autowired
    VehicleFeign vehicleFeign;

    @Autowired
    TourFeign tourFeign;

    @Autowired
    CampsiteFeign campsiteFeign;

    @Autowired
    SummitActivityBiz summitActivityBiz;


    /**
     * @param type 类型
     * @param number 随机数，默认是2
     * @return
     */
    public ObjectRestResponse getRandomList(Integer type, Integer number, Integer location) {
        if(type != null) {
            number = number == null ? 2 : number;
            switch (TypeEnum.getByValue(type)) {
                case VEHICLE:
                    return vehicleFeign.findRandomVehicle(number);
                case TOUR:
                    return tourFeign.findRandomVehicle(number);
                case CAMPSITE:
                    return campsiteFeign.findRandomVehicle(number);
                case ACTIVITY:
                    return ObjectRestResponse.succ(summitActivityBiz.getHostWithSummitActivity(number, location));
            }
        }
        return ObjectRestResponse.succ();
    }

}
