package com.xxfc.platform.vehicle.entity;

import lombok.Data;

import javax.persistence.*;
import java.util.Date;

@Table(name = "vehicle_book_record")
@Data
public class VehicleBookRecord {
    /**
     * 主键
     */
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;

    /**
     * 车辆id
     */
    private String vehicleId;

    /**
     * 申请状态：1-申请中 2-已通过 3-已归还 4-拒绝 5-逾期归还
     */
    private Integer status;

    /**
     * 预定类型，1-租车、2-分公司使用、3-维修、4、展览、5、旅游、6、保养、7、预约中、8、禁用
     */
    @Column(name = "book_type")
    private Integer bookType;

    /**
     * 申请预定用户id
     */
    @Column(name = "book_user")
    private Integer bookUser;

    /**
     * 申请预定用户姓名
     */
    @Column(name = "book_user_name")
    private String bookUserName;

    /**
     * 联系信息，比如电话、联系人姓名等(json)
     */
    @Column(name = "contact_info")
    private String contactInfo;

    /**
     * 申请开始日期
     */
    @Column(name = "book_start_date")
    private Date bookStartDate;

    /**
     * 提车地点(经纬度)
     */
    @Column(name = "lift_location")
    private String liftLocation;

    /**
     * 提车地址
     */
    @Column(name = "lift_addr")
    private String liftAddr;

    private String remark;

    /**
     * 目的地
     */
    private String destination;

    /**
     * 申请审核人，-1代表系统
     */
    @Column(name = "reviewer_apply")
    private Integer reviewerApply;

    /**
     * 申请审核人姓名
     */
    @Column(name = "reviewer_name_apply")
    private String reviewerNameApply;

    /**
     * 归还审核人，-1代表系统
     */
    @Column(name = "reviewer_return")
    private Integer reviewerReturn;

    /**
     * 归还审核人姓名
     */
    @Column(name = "reviewer_name_return")
    private String reviewerNameReturn;


    /**
     * 取消人，-1代表系统
     */
    @Column(name = "reviewer_cancel")
    private Integer reviewerCancel;

    /**
     * 取消人姓名
     */
    @Column(name = "reviewer_name_cancel")
    private String reviewerNameCancel;

    /**
     * 提车审核人，-1代表系统
     */
    private Integer reviewerLift;

    /**
     * 提车审核人姓名
     */
    private String reviewerNameLift;

    /**
     * 申请结束日期
     */
    @Column(name = "book_end_date")
    private Date bookEndDate;

    /**
     * 实际开始日期
     */
    @Column(name = "actual_start_date")
    private Date actualStartDate;

    /**
     * 实际结束日期
     */
    @Column(name = "actual_end_date")
    private Date actualEndDate;

    /**
     * 提车公司
     */
    private Integer liftCompany;

    /**
     * 提车备注
     */
    private String liftRemark;


    /**
     * 还车公司
     */
    private Integer retCompany;

    /**
     * 还车备注
     */
    private String retRemark;

    /**
     * 提车阶段里程数
     */
    private Integer mileageLift;

    /**
     * 还车阶段里程数
     */
    private Integer mileageRet;

    /**
     * 是否违章
     */
    private Integer haveViolation;

    /**
     * 订单号
     */
    private String orderNo;

    private String vehicleUsername;

    private String vehicleUserPhone;

    @Column(name = "vehicle_upkeep_item_ids")
    private String upkeepIds;
}