package com.xxfc.platform.universal.entity;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * 订单支付退款表
 * 
 * @author zjw
 * @email nishijjo@qq.com
 * @date 2019-05-28 16:17:42
 */
@Data
@Table(name = "order_refund")
public class OrderRefund implements Serializable {
	private static final long serialVersionUID = 1L;
	
	    //
    @Id
	@GeneratedValue(generator = "JDBC")
	@ApiModelProperty("")
    private Integer id;
	
	    //退款订单号
    @Column(name = "refund_trade_no")
	@ApiModelProperty(value = "退款订单号")
    private String refundTradeNo;
	
	    //订单号
    @Column(name = "order_no")
	@ApiModelProperty(value = "订单号")
    private String orderNo;
	
	    //用户id
    @Column(name = "user_id")
	@ApiModelProperty(value = "用户id")
    private Integer userId;
	
	    //0-订单生成,1-退款中,2-退款成功,3-退款失败
    @Column(name = "status")
	@ApiModelProperty(value = "0-订单生成,1-退款中,2-退款成功,3-退款失败")
    private Integer status;
	
	    //支付金额
    @Column(name = "amount")
	@ApiModelProperty(value = "支付金额")
    private Integer amount;
	
	    //退款金额
    @Column(name = "refund_amount")
	@ApiModelProperty(value = "退款金额")
    private Integer refundAmount;
	
	    //是否删除
    @Column(name = "is_del")
	@ApiModelProperty(value = "是否删除")
    private Integer isDel;
	
	    //商户退款单号
    @Column(name = "out_refund_no")
	@ApiModelProperty(value = "商户退款单号")
    private String outRefundNo;
	
	    //支付接口返回的流水号
    @Column(name = "serial_number")
	@ApiModelProperty(value = "支付接口返回的流水号")
    private String serialNumber;

	//退款描述
	@Column(name = "refund_desc")
	@ApiModelProperty(value = "退款描述")
	private String refundDesc;
	
	    //创建时间
    @Column(name = "crt_time")
	@ApiModelProperty(value = "创建时间", hidden = true )
    private Long crtTime;
	
	    //更新时间
    @Column(name = "upd_time")
	@ApiModelProperty(value = "更新时间", hidden = true )
    private Long updTime;
	
	    //退款完成时间
    @Column(name = "finish_time")
	@ApiModelProperty(value = "退款完成时间")
    private Long finishTime;
	

}
