package com.github.wxiaoqi.security.admin.rest;

import com.ace.cache.annotation.Cache;
import com.github.wxiaoqi.security.admin.biz.*;
import com.github.wxiaoqi.security.admin.entity.*;
import com.github.wxiaoqi.security.admin.feign.dto.AppUserDTO;
import com.github.wxiaoqi.security.admin.vo.AppUserGroups;
import com.github.wxiaoqi.security.admin.vo.AppUserVo;
import com.github.wxiaoqi.security.admin.vo.UserMemberVo;
import com.github.wxiaoqi.security.auth.client.config.UserAuthConfig;
import com.github.wxiaoqi.security.auth.client.jwt.UserAuthUtil;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.msg.TableResultResponse;
import com.github.wxiaoqi.security.common.rest.CommonBaseController;
import com.github.wxiaoqi.security.common.util.Query;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.beanutils.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.ws.rs.GET;
import java.util.List;
import java.util.Map;

/**
 * @author keliii
 */
@RestController
@RequestMapping("app/user")
@Slf4j
public class AppUserController extends CommonBaseController {

    @Autowired
    AppUserBiz appUserBiz;

    @Autowired
    private UserAuthUtil userAuthUtil;

    @Autowired
    private UserAuthConfig userAuthConfig;

    @Autowired
    AppUserDetailBiz userDetailBiz;

    @Autowired
    AppUserLoginBiz appUserLoginBiz;

    @Autowired
    private BaseUserMemberBiz userMemberBiz;

    @Autowired
    AppUserPositionBiz positionBiz;

    @Autowired
    private UserMemberLevelBiz userMemberLevelBiz;

    @Autowired
    private MyWaterBiz myWaterBiz;

    @GetMapping("page")
    public TableResultResponse list(@RequestParam Map<String, Object> params) {
        Query query = new Query(params);
        try {
            return appUserBiz.selectPage(query,
                    appUserBiz.getUserByUsername(userAuthUtil.getInfoFromToken(userAuthConfig.getToken(request)).getUniqueName()));
        }catch (Exception e) {
            log.error(e.getMessage());
            return new TableResultResponse<User>();
        }
    }

    @RequestMapping(value = "/{id}",method = RequestMethod.GET)
    @ResponseBody
    public ObjectRestResponse<AppUser> get(@PathVariable int id){
        ObjectRestResponse<AppUser> entityObjectRestResponse = new ObjectRestResponse<>();
        AppUser o = appUserBiz.selectById(id);
        entityObjectRestResponse.data(o);
        return entityObjectRestResponse;
    }

    @RequestMapping(value = "/{id}",method = RequestMethod.PUT)
    @ResponseBody
    public ObjectRestResponse<AppUser> update(@RequestBody AppUser entity){
        appUserBiz.updateSelectiveById(entity);
        return new ObjectRestResponse<AppUser>();
    }
    @RequestMapping(value = "/{id}",method = RequestMethod.DELETE)
    @ResponseBody
    public ObjectRestResponse<AppUser> remove(@PathVariable int id){
        appUserBiz.deleteById(id);
        return new ObjectRestResponse<AppUser>();
    }

    @RequestMapping(value = "/all",method = RequestMethod.GET)
    @ResponseBody
    public List<AppUser> all(){
        return appUserBiz.selectListAll();
    }

    @GetMapping("groups/{id}")
    public List<Group> groups(@PathVariable Integer id) {
        return appUserBiz.selectGroupsByAppUserId(id);
    }

    @PostMapping("groups")
    public ObjectRestResponse insertAppUserGroups(@RequestBody AppUserGroups appUserGroups) {
        appUserBiz.insertAppUserGroup(appUserGroups.getAppUserId(), appUserGroups.getGroups());
        return new ObjectRestResponse();
    }

    /**
     * 获取用户信息
     * @return
     * @throws Exception
     */
    @GetMapping("/info")
    public ObjectRestResponse<AppUserDTO> getUserInfo()throws Exception {
        String username = userAuthUtil.getInfoFromToken(userAuthConfig.getToken(request)).getId();
        if (username == null) {
            throw new Exception();
        }
        AppUserDTO userDTO=new AppUserDTO();
        Integer userid=Integer.parseInt(username);
        AppUserVo userVo = userDetailBiz.getUserInfoById(userid);
        if (userVo == null) {
            throw new Exception();
        }
        Integer id= userVo.getId();
       Integer positionId=userVo.getPositionId();
        BeanUtils.copyProperties(userDTO,userVo);
        if(userVo.getIsMember()!=null&&userVo.getIsMember()>0){
            //获取用户会员信息
            UserMemberVo memberVo=userMemberBiz.getMemberInfoByUserId(userid);
            if(memberVo!=null){
                BeanUtils.copyProperties(userDTO,memberVo);
                Integer level=memberVo.getMemberLevel();
                BaseUserMemberLevel memberLevel=userMemberLevelBiz.getLevel(level);
                if (memberLevel!=null){
                    String icon=memberLevel.getIcon();
                    userDTO.setIcon(icon);
                }
            }
        }
        AppUserPosition userPosition=positionBiz.selectById(positionId);
        if (userPosition!=null&&userPosition.getLevel()>0){
            userDTO.setPositionName(userPosition.getName());
        }
        userDTO.setId(id);
        return ObjectRestResponse.succ(userDTO);
    }


    @ApiOperation("获取用户收益")
    @GetMapping("/profit")
    public ObjectRestResponse profit() throws Exception{
        String username = userAuthUtil.getInfoFromToken(userAuthConfig.getToken(request)).getId();
        if (username == null) {
            throw new Exception();
        }
        Integer userid=Integer.parseInt(username);
        return myWaterBiz.getUserProfit(userid);
    }
    /**
     * 更新用户信息
     * @param userVo
     * @return
     * @throws Exception
     */
    @PostMapping("/edit")
    public ObjectRestResponse edit(@RequestBody AppUserVo userVo)throws Exception {
        if(userVo==null||userVo.getId()==null){
            return   ObjectRestResponse.createFailedResult(ResultCode.NULL_CODE, "参数为空");
        }
        userDetailBiz.updUuserInfoById(userVo);
        Integer userid=userVo.getUserid();
        if (userid!=null){
            AppUserLogin appUserLogin=new AppUserLogin();
            appUserLogin.setWxOpenid(userVo.getWxOpenid());
            appUserLogin.setUnionid(userVo.getUnionid());
            appUserLogin.setOpenid(userVo.getOpenid());
            appUserLogin.setId(userid);
            appUserLogin.setUsername(userVo.getUsername());
            appUserLoginBiz.bindOpenid(appUserLogin);
        }
        return ObjectRestResponse.succ();
    }

    /**
     * 更新用户信息
     * @param username
     * @return
     */
    @GetMapping("/one")
    public AppUserLogin one(@RequestParam(value = "username")String username){
        return appUserLoginBiz.getUserByUsername(username);
    }

    @GetMapping("/findusersByIds")
    public Map<Integer,AppUserLogin> findAppUsersByUserIds(@RequestParam(value = "userIds") List<Integer> userIds){
     return appUserLoginBiz.findUserIdAndUserLoginMapByMemberIds(userIds);
    }

    @GetMapping("/finduserIdsByphones")
    Map<String, Integer> findAppusersByUserNames(@RequestParam(value = "phones") List<String> phones){
        return appUserLoginBiz.findPhoneAndUserIdMapByPhones(phones);
    }
}
