package com.xxfc.platform.universal.feign;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.Map;

@FeignClient(value = "xx-universal", contextId = "sendMessage")
public interface MQSenderFeign {

    @GetMapping(value = "/message/sendMessage")
    public ObjectRestResponse sendMessage(@RequestParam(value = "exchange") String exchange, @RequestParam(value = "routKey")String routKey, @RequestParam(value = "json") String json);

    @PostMapping(value = "/message/sendMessage")
    public ObjectRestResponse postSendMessage(@RequestParam("entity") Map<String, Object> entity);

}
