package com.xxfc.platform.order;

import com.ace.cache.EnableAceCache;
import com.github.wxiaoqi.security.api.vo.config.HeaderConfig;
import com.github.wxiaoqi.security.auth.client.EnableAceAuthClient;
import com.github.wxiaoqi.security.common.annotation.AddBasicConfiguration;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.scheduling.annotation.EnableScheduling;

@SpringBootApplication(scanBasePackages = {
        "com.xxfc.platform",
        "com.github.wxiaoqi.security.common.handler"
//        ,
//        "com.github.wxiaoqi.security.common.log"
})
@EnableDiscoveryClient
@EnableScheduling
@EnableAceAuthClient
@EnableFeignClients(value = {"com.github.wxiaoqi.security.auth.client.feign", "com.github.wxiaoqi.security.admin.feign", "com.xxfc.platform"},defaultConfiguration = HeaderConfig.class)
@EnableAceCache
@AddBasicConfiguration
@tk.mybatis.spring.annotation.MapperScan(basePackages = "com.xxfc.platform.order.mapper")
public class OrderApplication {
    public static void main(String[] args) {
        SpringApplication.run(OrderApplication.class, args);
    }
}
