package com.xxfc.platform.order.biz;

import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.xxfc.platform.order.entity.DailyMembersOrderStatistics;
import com.xxfc.platform.order.entity.DailyTravelOrderStatistics;
import com.xxfc.platform.order.entity.OrderStatistics;
import com.xxfc.platform.order.mapper.DailyMembersOrderStatisticsMapper;
import com.xxfc.platform.order.mapper.DailyTravelOrderStatisticsMapper;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 每日购买会员订单统计
 *
 * @author Administrator
 */
@Service
@Slf4j
public class DailyMembersOrderStatisticsBiz extends BaseBiz<DailyMembersOrderStatisticsMapper, DailyMembersOrderStatistics> {

    private final Integer headOfficeId = 1;

    @Transactional(rollbackFor = Exception.class)
    public boolean memberOrderStatistics() {
        try {
            List<Map<String, Object>> travelGmv = mapper.getTravelGmv();
            if (CollectionUtils.isEmpty(travelGmv)) {
                return true;
            }
            for (Map<String, Object> stringObjectMap : travelGmv) {
                DailyMembersOrderStatistics MembersStatistics = new DailyMembersOrderStatistics();
                BeanUtils.copyProperties(MembersStatistics, stringObjectMap);
                insertSelective(MembersStatistics);
            }
            return true;
        } catch (Exception e) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public int insertSelectiveRe(DailyMembersOrderStatistics entity) {
        Date date = new Date();
        if (log.isDebugEnabled()){
            log.debug("时间******[{}]",date);
        }
        entity.setBranchCompanyId(headOfficeId);
        entity.setCrtTime(date);
        return mapper.insertSelective(entity);
    }

    public OrderStatistics findAll(Integer companyId) {
      return   mapper.monthOrderTotal(companyId);
    }
}
