package com.xxfc.platform.vehicle.rest;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreUserToken;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.xxfc.platform.vehicle.biz.VehicleBiz;
import com.xxfc.platform.vehicle.biz.VehicleHolidayPriceInfoBiz;
import com.xxfc.platform.vehicle.entity.Vehicle;
import com.xxfc.platform.vehicle.entity.VehicleHolidayPriceInfo;
import com.xxfc.platform.vehicle.pojo.dto.VehicleModelCalendarPriceDTO;
import com.xxfc.platform.vehicle.pojo.vo.VehicleVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("vehicleHolidayPriceInfo")
public class VehicleHolidayPriceInfoController extends BaseController<VehicleHolidayPriceInfoBiz, VehicleHolidayPriceInfo> {

	@Autowired
	VehicleBiz vehicleBiz;

	@PostMapping(value = "/saveOrUpdate")
	public ObjectRestResponse saveOrUpdate(@RequestBody VehicleHolidayPriceInfo vehicleHolidayPriceInfo) {
		return baseBiz.addOrUpdate(vehicleHolidayPriceInfo);
	}

	@GetMapping(value = "getByVehicleId")
	public  ObjectRestResponse getByVehicleId(String vehicleId, String startDate, String endDate) {
		return ObjectRestResponse.succ(baseBiz.getByVehicleIdAndDate(vehicleId, startDate, endDate));
	}

	@GetMapping(value = "getByVehicleIdFeign")
	@IgnoreUserToken
	public  ObjectRestResponse<List<VehicleModelCalendarPriceDTO>> getByVehicleIdFeign(String vehicleId, String startDate, String endDate, Integer userId, Integer companyId) {
		return ObjectRestResponse.succ(baseBiz.getSynthesizePrice(vehicleId, startDate, endDate, userId, companyId));
	}

	@GetMapping(value = "calendarPrice")
	@IgnoreUserToken
	public ObjectRestResponse<List<VehicleModelCalendarPriceDTO>> calendarPrice(String vehicleId, String startDate, String endDate, Integer companyId) {
		Integer userId = Integer.valueOf(getCurrentUserId());
		return ObjectRestResponse.succ(baseBiz.getSynthesizePrice(vehicleId, startDate, endDate, userId, companyId));
	}

	@GetMapping(value = "multiCalendarPrice")
	@IgnoreUserToken
	public ObjectRestResponse<List<VehicleVO>> multiCalendarPrice(String vehicleIds, String startDate, String endDate, Integer companyId) {
		Integer userId = Integer.valueOf(getCurrentUserId());

		List<VehicleVO> vehicleVOS = CollUtil.newArrayList();
		if(StrUtil.isNotBlank(vehicleIds)) {
			String[] strs = StrUtil.split(vehicleIds, ",");
			List<Vehicle> vehicleList = vehicleBiz.selectByWeekend(w -> {
				w.andIn(Vehicle::getId, CollUtil.toList(strs));
				return w;
			});
			for (Vehicle vehicle : vehicleList) {
				VehicleVO vehicleVO = BeanUtil.toBean(vehicle, VehicleVO.class);
				vehicleVO.setPriceDTOS(baseBiz.getSynthesizePrice(vehicle.getId(), startDate, endDate, userId, companyId));
				vehicleVOS.add(vehicleVO);
			}
		}
		return ObjectRestResponse.succ(vehicleVOS);
	}

	@GetMapping(value = "getAllByVehicleId")
	public  ObjectRestResponse getAllByVehicleId(String vehicleId) {
		return baseBiz.getByVehicleId(vehicleId);
	}

	@GetMapping(value = "getOne")
	public ObjectRestResponse getOne(Integer id) {
		return ObjectRestResponse.succ(baseBiz.selectById(id));
	}

	@GetMapping(value = "getAll")
	public ObjectRestResponse getAll(Integer festivalId) {
		return baseBiz.getAll(festivalId);
	}

}