package com.xxfc.platform.vehicle.entity;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;


/**
 * 车辆节假日价格信息表
 * 
 * @author libin
 * @email 18178966185@163.com
 * @date 2020-05-11 09:16:23
 */
@Data
@Table(name = "vehicle_holiday_price_info")
public class VehicleHolidayPriceInfo implements Serializable {
	private static final long serialVersionUID = 1L;
	
	    /**
    *  
   */
    @Id
	@GeneratedValue(generator = "JDBC")
	@ApiModelProperty("")
    private Integer id;
	
	    /**
     *  节日名称
     */
    @Column(name = "festival_day")
	@ApiModelProperty(value = "节日名称")
    private String festivalDay;
	
	    /**
     *  节日ID
     */
    @Column(name = "festival_id")
	@ApiModelProperty(value = "节日ID")
    private Integer festivalId;
	
	    /**
     *  节日时间
     */
    @Column(name = "festival_date")
	@ApiModelProperty(value = "节日时间")
    private Date festivalDate;
	
	    /**
     *  租车价格
     */
    @Column(name = "rent_price")
	@ApiModelProperty(value = "租车价格")
    private BigDecimal rentPrice;
	
	    /**
     *  免费天数
     */
    @Column(name = "rent_free_day")
	@ApiModelProperty(value = "免费天数")
    private Integer rentFreeDay;
	
	    /**
     *  
     */
    @Column(name = "vehicle_id")
	@ApiModelProperty(value = "")
    private String vehicleId;
	
	    /**
     *  
     */
    @Column(name = "model_id")
	@ApiModelProperty(value = "")
    private Integer modelId;
	
	    /**
     *  是否所有车型使用:0否，1是
     */
    @Column(name = "all_model_use")
	@ApiModelProperty(value = "是否所有车型使用:0否，1是")
    private Integer allModelUse;
	
	    /**
     *  是否所有车辆使用：0否，1、是
     */
    @Column(name = "all_vehicle_use")
	@ApiModelProperty(value = "是否所有车辆使用：0否，1、是")
    private Integer allVehicleUse;
	
	    /**
     *  所属公司
     */
    @Column(name = "company_id")
	@ApiModelProperty(value = "所属公司")
    private Integer companyId;
	
	    /**
     *  
     */
    @Column(name = "crt_time")
	@ApiModelProperty(value = "", hidden = true )
    private Date crtTime;
	
	    /**
     *  
     */
    @Column(name = "upd_time")
	@ApiModelProperty(value = "", hidden = true )
    private Date updTime;

	@Column(name = "is_del")
	private Integer isDel;

	@Transient
	private String startDate;

	@Transient
	private String endDate;
}
