package com.xxfc.platform.activity.rest;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.xxfc.platform.activity.biz.TicketCollectionRecordBiz;
import com.xxfc.platform.activity.entity.TicketCollectionRecord;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping(value = "ticketCollection")
public class TicketCollectionRecordController extends BaseController<TicketCollectionRecordBiz, TicketCollectionRecord> {

	@PostMapping(value = "/app/unauth/add")
	public ObjectRestResponse add(@RequestBody TicketCollectionRecord ticketCollectionRecord) {
		return baseBiz.add(ticketCollectionRecord);
	}

	@GetMapping(value = "/app/unauth/getAll")
	public ObjectRestResponse<List<TicketCollectionRecord>> getAll(Integer type) {
		return baseBiz.selectAllByType(type);
	}

}
