package com.xxfc.platform.user.behavior.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/8/12 14:13
 */
@Data
public class CustomerBehaviorNoteDTO implements Serializable {

    private static final long serialVersionUID = 1L;
    @ApiModelProperty("主键id")
    private Integer id;

    @ApiModelProperty(value = "用户id")
    private String customerId;

    /**
     * 访问者身份 {@link com.xxfc.platform.user.behavior.common.IdentityEnum}
     */
    @ApiModelProperty(value = "1-游客；2-用户")
    private Integer customerType;

    /**
     *  行为类型 {@link com.xxfc.platform.user.behavior.common.BehaviorEnum}
     */
    @ApiModelProperty(value = "行为类型（见枚举）")
    private Integer type;


    @ApiModelProperty(value = "类型id")
    private Integer typeId;

    @ApiModelProperty(value = "请求id")
    private String requestId;
}
