package com.xxfc.platform.vehicle.entity;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.*;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * 车型
 * 
 * @author zjw
 * @email nishijjo@qq.com
 * @date 2019-05-25 14:50:08
 */
@Data
@Table(name = "vehicle_model")
public class VehicleModel implements Serializable {
	private static final long serialVersionUID = 1L;
	
	    //主键
    @Id
	@GeneratedValue(generator = "JDBC")
	@ApiModelProperty("主键")
    private Integer id;
	
	    //名称
    @Column(name = "name")
	@ApiModelProperty(value = "名称")
    private String name;
	
	    //牌照
    @Column(name = "license_plate")
	@ApiModelProperty(value = "牌照")
    private String licensePlate;
	
	    //厂家
    @Column(name = "factory")
	@ApiModelProperty(value = "厂家")
    private Integer factory;
	
	    //车型
    @Column(name = "category")
	@ApiModelProperty(value = "车型")
    private Integer category;
	
	    //长度mm
    @Column(name = "length")
	@ApiModelProperty(value = "长度mm")
    private Integer length;
	
	    //宽度mm
    @Column(name = "width")
	@ApiModelProperty(value = "宽度mm")
    private Integer width;
	
	    //高度mm
    @Column(name = "high")
	@ApiModelProperty(value = "高度mm")
    private Integer high;
	
	    //乘坐人数
    @Column(name = "seating")
	@ApiModelProperty(value = "乘坐人数")
    private Integer seating;
	
	    //离地空隙mm
    @Column(name = "above_ground")
	@ApiModelProperty(value = "离地空隙mm")
    private Integer aboveGround;
	
	    //排量
    @Column(name = "displacement")
	@ApiModelProperty(value = "排量")
    private Integer displacement;
	
	    //燃油类型
    @Column(name = "fuel_type")
	@ApiModelProperty(value = "燃油类型")
    private Integer fuelType;
	
	    //功率
    @Column(name = "power")
	@ApiModelProperty(value = "功率")
    private Integer power;
	
	    //最大扭矩
    @Column(name = "max_torque")
	@ApiModelProperty(value = "最大扭矩")
    private Integer maxTorque;
	
	    //驱动形式
    @Column(name = "drive_type")
	@ApiModelProperty(value = "驱动形式")
    private Integer driveType;
	
	    //变速箱
    @Column(name = "gearbox")
	@ApiModelProperty(value = "变速箱")
    private Integer gearbox;
	
	    //油箱大小
    @Column(name = "fuel_tank_size")
	@ApiModelProperty(value = "油箱大小")
    private Integer fuelTankSize;
	
	    //排放标准
    @Column(name = "emission_standard")
	@ApiModelProperty(value = "排放标准")
    private Integer emissionStandard;
	
	    //最高车速
    @Column(name = "max_speed")
	@ApiModelProperty(value = "最高车速")
    private Integer maxSpeed;
	
	    //清水箱大小
    @Column(name = "water_tank_size")
	@ApiModelProperty(value = "清水箱大小")
    private Integer waterTankSize;
	
	    //灰水箱大小
    @Column(name = "grey_water_tank_size")
	@ApiModelProperty(value = "灰水箱大小")
    private Integer greyWaterTankSize;
	
	    //黑水箱大小
    @Column(name = "black_water_tank_size")
	@ApiModelProperty(value = "黑水箱大小")
    private Integer blackWaterTankSize;
	
	    //马    桶
    @Column(name = "closestool")
	@ApiModelProperty(value = "马    桶")
    private Integer closestool;
	
	    //配置，code逗号分割
    @Column(name = "config")
	@ApiModelProperty(value = "配置，code逗号分割")
    private String config;
	
	    //关键字，code逗号分割
    @Column(name = "keyword")
	@ApiModelProperty(value = "关键字，code逗号分割")
    private String keyword;
	
	    //评分
    @Column(name = "point")
	@ApiModelProperty(value = "评分")
    private Integer point;
	
	    //图片地址 多张为逗号分割
    @Column(name = "picture")
	@ApiModelProperty(value = "图片地址 多张为逗号分割")
    private String picture;

	//价格
	@Column(name = "price")
	@ApiModelProperty(value = "价格")
	private BigDecimal price;
	
	    //创建时间
    @Column(name = "crt_time")
	@ApiModelProperty(value = "创建时间", hidden = true )
    private Date crtTime;
	
	    //创建者id
    @Column(name = "crt_user")
	@ApiModelProperty(value = "创建者id")
    private Integer crtUser;
	
	    //创建者名称
    @Column(name = "crt_name")
	@ApiModelProperty(value = "创建者名称")
    private String crtName;
	
	    //创建者host
    @Column(name = "crt_host")
	@ApiModelProperty(value = "创建者host")
    private String crtHost;
	
	    //修改时间
    @Column(name = "upd_time")
	@ApiModelProperty(value = "修改时间", hidden = true )
    private Date updTime;
	
	    //修改者
    @Column(name = "upd_user")
	@ApiModelProperty(value = "修改者")
    private Integer updUser;
	
	    //修改者名称
    @Column(name = "upd_name")
	@ApiModelProperty(value = "修改者名称")
    private String updName;
	
	    //修改者host
    @Column(name = "upd_host")
	@ApiModelProperty(value = "修改者host")
    private String updHost;

	//评分
	@Column(name = "score")
	@ApiModelProperty(value = "评分")
	private Integer score;
	

}
