package com.github.wxiaoqi.security.common.vo;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import lombok.Data;

import java.util.List;

@Data
public  class PageDataVO<T> {
    /**
     * 符合条件记录总数
     */
    private Long totalCount;

    private Integer totalPage;

    private Integer pageNum;

    private Integer pageSize;

    /**
     * 实际数据
     */
    private List<T> data;

    public static <M> PageDataVO<M> pageInfo(PageInfo<M> pageInfo){
        PageDataVO<M> pageDataVo = new PageDataVO<>();
        pageDataVo.setTotalCount(pageInfo.getTotal());
        pageDataVo.setData(pageInfo.getList());
        pageDataVo.setPageNum(pageInfo.getPageNum());
        pageDataVo.setTotalPage(pageInfo.getPages());
        pageDataVo.setPageSize(pageInfo.getSize());
        return pageDataVo;
    }

    public static <M> PageDataVO<M> pageInfo(Integer page, Integer limit, List<M> list){
        PageHelper.startPage(page,limit);
        PageInfo<M> listPageInfo = new PageInfo<M>(list);
        return pageInfo(listPageInfo);
    }

}
