package com.xxfc.platform.vehicle.biz;

import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.xxfc.platform.vehicle.entity.BookRecordUpdateLog;
import com.xxfc.platform.vehicle.mapper.BookRecordUpdateLogMapper;
import org.springframework.stereotype.Service;
import tk.mybatis.mapper.entity.Example;

import java.util.List;

@Service
public class BookRecordUpdateLogBiz extends BaseBiz<BookRecordUpdateLogMapper, BookRecordUpdateLog> {

    public ObjectRestResponse save(BookRecordUpdateLog bookRecordUpdateLog) {
        BookRecordUpdateLog oldValue = mapper.selectOne(bookRecordUpdateLog);
        if (oldValue != null) {
            return ObjectRestResponse.succ();
        }
        insertSelectiveRe(bookRecordUpdateLog);
        return ObjectRestResponse.succ();
    }

    public ObjectRestResponse<List<BookRecordUpdateLog>> selectByBookRecordId(Long bookRecordId) {
        Example example = new Example(BookRecordUpdateLog.class);
        example.createCriteria().andEqualTo("bookRecordId", bookRecordId);
        example.setOrderByClause("create_time desc");
        return ObjectRestResponse.succ(selectByExample(example));
    }

}
