package com.xxfc.platform.vehicle.rest;

import com.github.wxiaoqi.security.admin.feign.UserFeign;
import com.github.wxiaoqi.security.admin.feign.dto.UserDTO;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreClientToken;
import com.github.wxiaoqi.security.auth.client.config.UserAuthConfig;
import com.xxfc.platform.vehicle.biz.VehicleBiz;
import com.xxfc.platform.vehicle.biz.VehicleDepartureService;
import com.xxfc.platform.vehicle.common.RestResponse;
import com.xxfc.platform.vehicle.constant.ResCode.ResCode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

@IgnoreClientToken
@RestController
@RequestMapping("departure")
public class VehicleDepartureController {

    @Autowired
    VehicleDepartureService vehicleDepartureService;
    @Autowired
    VehicleBiz vehicleBiz;

    @Autowired
    UserFeign userFeign;

    @Autowired
    private UserAuthConfig userAuthConfig;

    @GetMapping("page")
    public RestResponse page(String numberPlate, Integer page, Integer limit, HttpServletRequest request) {
        if (page == null || limit == null) {
            page = 1;
            limit = 10;
        }
        UserDTO userDTO = userFeign.userinfoByToken(userAuthConfig.getToken(request)).getData();
        if (userDTO != null) {
            if (userDTO.getDataAll() == 2) {
                List<Integer> companyList = vehicleBiz.dataCompany(userDTO.getDataZone(), userDTO.getDataCompany());
                return RestResponse.data(vehicleDepartureService.pageNotAllData(numberPlate, page, limit, companyList));
            }
        }
        return RestResponse.suc(vehicleDepartureService.page(numberPlate, page, limit));
    }

    @GetMapping("findByVehicle")
    public RestResponse findByVehicle(String vehicleId, Integer page, Integer limit) {
        if (vehicleId == null) {
            return RestResponse.codeAndMessage(ResCode.INVALID_REST_REQ_PARAM.getCode(),
                    ResCode.INVALID_REST_REQ_PARAM.getDesc());
        }
        if (page == null || limit == null) {
            page = 1;
            limit = 10;
        }
        return RestResponse.suc(vehicleDepartureService.findByVehicle(vehicleId, page, limit));
    }

    @GetMapping("statistic")
    public RestResponse statistic(String numberPlate) {
        if (numberPlate == null) {
            return RestResponse.codeAndMessage(ResCode.INVALID_REST_REQ_PARAM.getCode(),
                    ResCode.INVALID_REST_REQ_PARAM.getDesc());
        }
        return RestResponse.suc(vehicleDepartureService.statistic(numberPlate));
    }


}
